import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增培训项目
  addCmgtSaftyTrainingProject(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainProject/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改培训项目
  editCmgtSaftyTrainingProject(data, cb) {
    req.put(portal + `/manager/cmgtSaftyTrainProject/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询培训项目
  loadCmgtSaftyTrainingProject(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainProject/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询实体
  cmgtSaftyTrainProjectId(data, cb) {
    req.get(portal + `/manager/cmgtSaftyTrainProject/`+data).then(res => {
      cb(res.data)
    })
  },
    // 根据id查询实体
  cmgtSaftyPlanId(id, cb) {
    req.get(portal + `/manager/cmgtSaftyPlan/`+id).then(res => {
      cb(res.data)
    })
  },
    // 年度计划查询接口
  loadcmgtSaftyPlan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyPlan/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除培训项目
      deleteCmgtSaftyTrainingProject(data) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/manager/cmgtSaftyTrainProject/delete?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}
