## 表格组件

+ `ht-table`[表格组件](#1)
- `ht-table-search-panel`[高级搜索面板](#2)
- `ht-table-search-field`[高级搜索字段](#3)
- `ht-table-column`[表格的列](#4)

## 1.表格组件
表格组件的代码如下所示：
```html
<ht-table
    @load="loadData"
    :data="data"
    :pageResult="pageResult"
    :selection="true"
    quick-search-props="account,name,mobile">
</ht-table>
```

### 属性说明
|属性|类型|默认值|说明|
|:---|:---|:---|:---|
|data|array|-|表格的数据，格式为数组|
|page-result|object|`{ page: 1, pageSize: 50, total: 0 }`|分页对象，`page`表示当前页，`pageSize`表示每页条数，`total`表示总数|
|page-sizes|Array|[10, 20, 50, 100, 200, 300, 500]|每页条数下拉可选项|
|default-querys|Array|[]|默认查询条件，group:"defaultQueryGroup",operation: "EQUAL",relation: "AND" 为默认值 :default-querys="[{property:'account',value:'lisi'}]"  :default-querys="[{property:'account',value:'lisi',operation: "LIKE"  }]" |
|default-sorter|Array|[]|默认排序规则,如果设置了默认排序的列,该列不支持更改排序规则，只能使用默认的排序规则  direction 支持DESC 和 ASC    :default-sorter="[{direction: 'DESC',property: 'name'}]"   |
|selectable|boolean|true|表示第一列是否显示复选框|
|quick-search-props|string/array|-|快速搜索，格式为`string`时提供逗号分割的任意多个属性`"name,account,email"`，而且这些属性必须与表格的列中`prop`能够对应；格式为`array`时为`[{prop:"name",label:"姓名"},{prop:"u.account_",label:"账号"}]`的格式，此时`prop`可以不对应表格的列。|
|debounce|number|800|快速搜索中，用户输入搜索内容时停顿时间超过这个时间（单位：毫秒）即开始执行搜索操作。|
|show-export|boolean|true|是否显示导出数据的按钮|
|show-custom-column|boolean|true|是否显示自定义显示列的按钮|
|nopagination|boolean|false|false 显示分页组件 true 不显示分页组件 |

### 方法说明
|方法|说明|
|:---|:---|
|load(doNotResetPage)|触发查询，参数`doNotResetPage`不传或者传`false`时，会将页码重置为第一页来查询，传`true`时，会按照当前页码来查询。|

### 事件说明
|事件|说明|参数|
|:---|:---|:---|
|load|表格加载数据时会触发的事件|param|
|row-click|当用户点击某一行数据时触发的事件|row,column,event|
|row-dblclick|当用户双击某一行数据时触发的事件|row,column,event|
|select|当用户手动勾选数据行的 Checkbox 时触发的事件(要获取当前表格所选中的数据，可以通过`this.refs.table.selection`获取)|selection,row|
|select-all|当用户手动勾选全选 Checkbox 时触发的事件|selection|
|sort-change|当用户执行排序操作时触发的事件|column|
|filter-change|当用户选择对某一列进行筛选时触发的事件|prop|

`load`事件中的`param`参数，格式如下：
```javascript
{
    pageBean: {
        page: 1,
        pageSize: 50
    },
    sorter: [
        {property: "age", direction: "ASC"}
    ],
    querys: [
        {property: "name", operation: "LIKE", value: "", group: "filter", relation: "AND"},
        {property: "account", operation: "LIKE", value: "", group: "filter", relation: "AND"}
    ],
    groupRelation: "AND"
}
```
以上`param`的各项参数说明如下：
+ `pageBean`分页对象，`page`为当前页码，`pageSize`为每一页的条数；
- `sorter`排序对象，`property`为要排序的字段，`direction`为排序的方向，可选值为：`ASC`,`DESC`；
- `querys`查询对象，查询对象中各个参数说明如下：
    * `property`为查询字段；
    * `value`为参数的值；
    * `group`为查询条件所属分组，分组名相同的多个条件会组合为一个查询分组；
    * `relation`为当前分组中多个条件之间的组合关系，可选值有`AND`,`OR`，在同一组中，只有第一个查询条件中的`relation`生效且整组都以这个关系来组合；
    * `operation`为查询操作类型，可选值有：
        1. `EQUAL`等于
        2. `EQUAL_IGNORE_CASE`忽略大小写等于
        2. `LESS`小于
        2. `GREAT`大于
        2. `LESS_EQUAL`小于等于
        2. `GREAT_EQUAL`大于等于
        2. `NOT_EQUAL`不等于
        2. `LIKE`类似
        2. `LEFT_LIKE`左类似
        2. `RIGHT_LIKE`右类似
        2. `IS_NULL`为空
        2. `NOTNULL`不为空
        2. `IN`在集合中
        2. `BETWEEN`介于
- `groupRelation`多组查询条件之间的组合关系，可选值：`AND`,`OR`。


### 表格高度自适应


+ 表格在渲染时会自适应高度，按照给定的容器100%填充整个容器高度。但是可能在渲染时容器高度未最终确定，此时只需要触发`$root.$emit("resize")`事件，则表格会再次自适应高度。
- 另外因为Vue单页面的特殊性，`window.onresize`事件只能被监听一次，而在页面调整尺寸时，表格也需要自适应高度，所以此时也需要通过`$root.$emit("resize")`事件来触发表格自适应高度。
> 我们建议在每个项目的App.vue组件中的`mounted()`中统一监听`window`的`onresize`事件，然后以`$root.$emit("resize")`来发送该事件。

## 2.高级搜索面板

如下面的代码所示，高级搜索面板对应的组件为`ht-table-search-panel`，因为该搜索面板要出现在表格中的特定位置，所以我们以插槽`<template v-slot:search>`的形式放在`<ht-table>`中。

```html
<template v-slot:search>
    <ht-table-search-panel :divide="3">
        <ht-table-search-field label="姓名" prop="name" />
        <ht-table-search-field label="账号" prop="account" />
        <ht-table-search-field label="邮箱" prop="email" />
        <ht-table-search-field label="电话" prop="mobile" />
    </ht-table-search-panel>
</template>
```

### 属性说明
|属性|类型|默认值|说明|
|:---|:---|:---|:---|
|divide|搜索条件分为几列|4|在搜索条件较多时，搜索面板会按照每行`divide`列的方式来展示搜索条件，该属性的可选值为`0<divide<5`的整数。|
|label-width|搜索条件中标签的宽度(px)|70|搜索条件中标签部分的宽度|


## 3.高级搜索字段
如下面的代码所示，`<ht-table-search-field />` 必须出现在`<ht-table-search-panel>`中。
不设置type  默认为text
```html
<ht-table-search-field label="姓名" prop="name" />
```
type="select"
```html
<ht-table-search-field label="状态" prop="status" type="select" :options="[{value:'男士', key:'0'},{value:'女士', key:'1'}]" />
```
type="date"
```html
<ht-table-search-field label="创建时间" prop="createTime" type="date"/>
```


### 属性说明
|属性|类型|默认值|说明|
|:---|:---|:---|:---|
|prop|string|-|用于查询的参数属性名，必填。|
|operation|string|LIKE|查询时的操作类型，其可选值与上述表格组件中`param`参数中`querys`中的`operation`的可选值一致。|
|relation|string|AND|多个查询条件之间的组合关系，可选值`AND`,`OR`。|
|label|string|-|查询条件的标签内容|
|label-width|number|默认会由`ht-table-search-panel`传入|查询条件标签的宽度|
|type|string|text|查询条件的类型，可选值：`text`,`date`,`daterange`|



## 4.表格的列

代码如下所示，通过`ht-table-column`来配置表格显示的列。

```html
<ht-table-column
        prop="name"
        label="名称"
        width="300"
        :sortable="true"
        :show-overflow-tooltip="true"/>
```

### 属性说明
|属性|类型|默认值|说明|
|:---|:---|:---|:---|
|type|string|-|对应列的类型。如果设置了`selection`则显示多选框；如果设置了`index`则显示该行的索引（从 1 开始计算）；如果设置了`expand`则显示为一个可展开的按钮|
|align|string|center|列在横向上的布局方式，可选值有`left`,`center`,`right`。|
|prop|string|-|列对应的属性，必须与`data`返回的数据的属性对应上。|
|label|string|-|列标签|
|width|string|-|对应列的宽度|
|sortable|boolean|false|当前列是否支持排序|
|filters|Array[{text, value}]|-|数据过滤的选项，数组格式，数组中的元素需要有`text`和`value`属性。|
|show-overflow-tooltip|boolean|false|当内容过长被隐藏时显示 tooltip。|
|fixed|string,boolean|-|列是否固定在左侧或者右侧，true 表示固定在左侧。为字符串时可选值有：`left`,`right`|
|formatter|Function(row, column, cellValue, index)|-|用来格式化内容|
|renderHeader|Function(h, { column, $index })|-|列标题 Label 区域渲染使用的 Function|
|hidden|boolean|false|默认是否隐藏列，隐藏的列在自定义显示列对话框中可以勾选显示。|

### 插槽
|name|说明|
|:---|:---|
|-|自定义列的内容，参数为{ row, column, cellValue, index }|
|header|自定义表头的内容，参数为{ column, $index }|