"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.adaptor = exports.nodeDraggable = exports.animation = void 0;
var tslib_1 = require("tslib");
var util_1 = require("@antv/util");
var common_1 = require("../../adaptor/common");
var utils_1 = require("../../utils");
var geometries_1 = require("../../adaptor/geometries");
var helper_1 = require("./helper");
var constant_1 = require("./constant");
/**
 * 默认配置项 处理
 * @param params
 */
function defaultOptions(params) {
    var options = params.options;
    var _a = options.rawFields, rawFields = _a === void 0 ? [] : _a;
    return utils_1.deepAssign({}, {
        options: {
            tooltip: {
                fields: util_1.uniq(tslib_1.__spreadArrays(['name', 'source', 'target', 'value', 'isNode'], rawFields)),
            },
            label: {
                fields: util_1.uniq(tslib_1.__spreadArrays(['x', 'name'], rawFields)),
            },
        },
    }, params);
}
/**
 * geometry 处理
 * @param params
 */
function geometry(params) {
    var chart = params.chart, options = params.options;
    var color = options.color, nodeStyle = options.nodeStyle, edgeStyle = options.edgeStyle, label = options.label, tooltip = options.tooltip, nodeState = options.nodeState, edgeState = options.edgeState;
    // 1. 组件，优先设置，因为子 view 会继承配置
    chart.legend(false);
    chart.tooltip(tooltip);
    chart.axis(false);
    // y 镜像一下，防止图形顺序和数据顺序反了
    chart.coordinate().reflect('y');
    // 2. node edge views
    // @ts-ignore
    var _a = helper_1.transformToViewsData(options, chart.width, chart.height), nodes = _a.nodes, edges = _a.edges;
    // edge view
    var edgeView = chart.createView({ id: constant_1.EDGES_VIEW_ID });
    edgeView.data(edges);
    geometries_1.edge({
        chart: edgeView,
        // @ts-ignore
        options: {
            xField: constant_1.X_FIELD,
            yField: constant_1.Y_FIELD,
            seriesField: constant_1.COLOR_FIELD,
            edge: {
                color: color,
                style: edgeStyle,
                shape: 'arc',
            },
            tooltip: tooltip,
            state: edgeState,
        },
    });
    var nodeView = chart.createView({ id: constant_1.NODES_VIEW_ID });
    nodeView.data(nodes);
    geometries_1.polygon({
        chart: nodeView,
        options: {
            xField: constant_1.X_FIELD,
            yField: constant_1.Y_FIELD,
            seriesField: constant_1.COLOR_FIELD,
            polygon: {
                color: color,
                style: nodeStyle,
            },
            label: label,
            tooltip: tooltip,
            state: nodeState,
        },
    });
    chart.interaction('element-active');
    // scale
    chart.scale({
        x: { sync: true, nice: true, min: 0, max: 1, minLimit: 0, maxLimit: 1 },
        y: { sync: true, nice: true, min: 0, max: 1, minLimit: 0, maxLimit: 1 },
        name: { sync: 'color', type: 'cat' },
    });
    return params;
}
/**
 * 动画
 * @param params
 */
function animation(params) {
    var chart = params.chart, options = params.options;
    var animation = options.animation;
    // 同时设置整个 view 动画选项
    if (typeof animation === 'boolean') {
        chart.animate(animation);
    }
    else {
        chart.animate(true);
    }
    var geometries = tslib_1.__spreadArrays(chart.views[0].geometries, chart.views[1].geometries);
    // 所有的 Geometry 都使用同一动画（各个图形如有区别，自行覆盖）
    geometries.forEach(function (g) {
        g.animate(animation);
    });
    return params;
}
exports.animation = animation;
/**
 * 节点拖动
 * @param params
 */
function nodeDraggable(params) {
    var chart = params.chart, options = params.options;
    var nodeDraggable = options.nodeDraggable;
    var DRAG_INTERACTION = 'sankey-node-draggable';
    if (nodeDraggable) {
        chart.interaction(DRAG_INTERACTION);
    }
    else {
        chart.removeInteraction(DRAG_INTERACTION);
    }
    return params;
}
exports.nodeDraggable = nodeDraggable;
/**
 * Interaction 配置
 * @param params
 */
function interaction(params) {
    var chart = params.chart, options = params.options;
    var _a = options.interactions, interactions = _a === void 0 ? [] : _a;
    var nodeInteractions = [].concat(interactions, options.nodeInteractions || []);
    var edgeInteractions = [].concat(interactions, options.edgeInteractions || []);
    var nodeView = utils_1.findViewById(chart, constant_1.NODES_VIEW_ID);
    var edgeView = utils_1.findViewById(chart, constant_1.EDGES_VIEW_ID);
    nodeInteractions.forEach(function (i) {
        if ((i === null || i === void 0 ? void 0 : i.enable) === false) {
            nodeView.removeInteraction(i.type);
        }
        else {
            nodeView.interaction(i.type, i.cfg || {});
        }
    });
    edgeInteractions.forEach(function (i) {
        if ((i === null || i === void 0 ? void 0 : i.enable) === false) {
            edgeView.removeInteraction(i.type);
        }
        else {
            edgeView.interaction(i.type, i.cfg || {});
        }
    });
    return params;
}
/**
 * 图适配器
 * @param chart
 * @param options
 */
function adaptor(params) {
    // flow 的方式处理所有的配置到 G2 API
    return utils_1.flow(defaultOptions, geometry, interaction, nodeDraggable, animation, common_1.theme
    // ... 其他的 adaptor flow
    )(params);
}
exports.adaptor = adaptor;
//# sourceMappingURL=adaptor.js.map