"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProgressData = void 0;
var util_1 = require("@antv/util");
var number_1 = require("../../utils/number");
/**
 * 获取进度条数据
 */
function getProgressData(percent) {
    var clampPercent = util_1.clamp(number_1.isRealNumber(percent) ? percent : 0, 0, 1);
    return [
        {
            type: 'current',
            percent: clampPercent,
        },
        {
            type: 'target',
            percent: 1 - clampPercent,
        },
    ];
}
exports.getProgressData = getProgressData;
//# sourceMappingURL=utils.js.map