/**
 * bullet 处理数据
 * @param options
 */
export function transformData(options) {
    var data = options.data, xField = options.xField, measureField = options.measureField, rangeField = options.rangeField, targetField = options.targetField, layout = options.layout;
    var ds = [];
    var scales = [];
    data.forEach(function (item, index) {
        var _a;
        // 构建 title * range
        item[rangeField].sort(function (a, b) { return a - b; });
        item[rangeField].forEach(function (d, i) {
            var _a;
            var range = i === 0 ? d : item[rangeField][i] - item[rangeField][i - 1];
            ds.push((_a = {
                    rKey: rangeField + "_" + i
                },
                _a[xField] = xField ? item[xField] : String(index),
                _a[rangeField] = range,
                _a));
        });
        // 构建 title * measure
        item[measureField].forEach(function (d, i) {
            var _a;
            ds.push((_a = {
                    mKey: item[measureField].length > 1 ? measureField + "_" + i : "" + measureField
                },
                _a[xField] = xField ? item[xField] : String(index),
                _a[measureField] = d,
                _a));
        });
        // 构建 title * target
        ds.push((_a = {
                tKey: "" + targetField
            },
            _a[xField] = xField ? item[xField] : String(index),
            _a[targetField] = item[targetField],
            _a));
        // 为了取最大值和最小值，先存储
        scales.push(item[rangeField], item[measureField], item[targetField]);
    });
    // scales 是嵌套的需要拍平
    var min = Math.min.apply(Math, scales.flat(Infinity));
    var max = Math.max.apply(Math, scales.flat(Infinity));
    // min 大于 0 从 0 开始
    min = min > 0 ? 0 : min;
    // 垂直情况，需要反转数据
    if (layout === 'vertical') {
        ds.reverse();
    }
    return { min: min, max: max, ds: ds };
}
//# sourceMappingURL=utils.js.map