import { Geometry, View, Element } from '@antv/g2';
/**
 * 在 View 中查找第一个指定 type 类型的 geometry
 * @param view
 * @param type
 */
export declare function findGeometry(view: View, type: string): Geometry;
/**
 * 获取 View 的 所有 elements
 */
export declare function getAllElements(view: View): Element[];
/**
 * 递归获取 View 的 所有 elements, 包括 View 的子 View
 */
export declare function getAllElementsRecursively(view: View): Element[];
/**
 * 递归获取 View 的 所有 geometries, 包括 View 的子 View
 */
export declare function getAllGeometriesRecursively(view: View): Geometry[];
