import { __assign } from "tslib";
import { getTooltipMapping } from '../../utils/tooltip';
import { deepAssign } from '../../utils';
import { geometry } from './base';
/**
 * schema 的配置处理
 * @param params
 */
export function schema(params) {
    var options = params.options;
    var schema = options.schema, xField = options.xField, yField = options.yField, seriesField = options.seriesField, tooltip = options.tooltip;
    var _a = getTooltipMapping(tooltip, [xField, yField, seriesField]), fields = _a.fields, formatter = _a.formatter;
    return schema
        ? geometry(deepAssign({}, params, {
            options: {
                type: 'schema',
                colorField: seriesField,
                tooltipFields: fields,
                mapping: __assign({ tooltip: formatter }, schema),
            },
        }))
        : params;
}
//# sourceMappingURL=schema.js.map