import { BBox } from '../dependents';
declare type Box = Pick<BBox, 'x' | 'y' | 'width' | 'height'> & {
    rotation?: number;
};
/**
 * 快速判断两个无旋转矩形是否遮挡
 */
export declare function isIntersectRect(box1: Box, box2: Box, margin?: number): boolean;
/**
 * detect whether two shape is intersected, useful when shape is been rotated
 * 判断两个矩形是否重叠（相交和包含, 是否旋转）
 *
 * - 原理: 分离轴定律
 */
export declare function isIntersect(box1: Box, box2: Box): boolean;
export {};
