"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var base_1 = (0, tslib_1.__importDefault)(require("./base"));
/** 引入 Point 对应的 ShapeFactory */
require("./shape/point");
/**
 * Point 几何标记。
 * 常用于绘制点图。
 */
var Point = /** @class */ (function (_super) {
    (0, tslib_1.__extends)(Point, _super);
    function Point() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.type = 'point';
        _this.shapeType = 'point';
        _this.generatePoints = true;
        return _this;
    }
    /**
     * 获取一个点的绘制信息。
     * @param mappingDatum
     * @returns draw cfg
     */
    Point.prototype.getDrawCfg = function (mappingDatum) {
        var shapeCfg = _super.prototype.getDrawCfg.call(this, mappingDatum);
        return (0, tslib_1.__assign)((0, tslib_1.__assign)({}, shapeCfg), { isStack: !!this.getAdjust('stack') });
    };
    return Point;
}(base_1.default));
exports.default = Point;
//# sourceMappingURL=point.js.map