import { ControllerCtor } from './base';
/**
 * 全局注册组件。
 * @param name 组件名称
 * @param plugin 注册的组件类
 * @returns void
 */
export declare function registerComponentController(name: string, plugin: ControllerCtor): void;
/**
 * 删除全局组件。
 * @param name 组件名
 * @returns void
 */
export declare function unregisterComponentController(name: string): void;
/**
 * 获取以注册的组件名。
 * @returns string[] 返回已注册的组件名称
 */
export declare function getComponentControllerNames(): string[];
/**
 * 根据组件名获取组件类。
 * @param name 组件名
 * @returns 返回组件类
 */
export declare function getComponentController(name: string): ControllerCtor;
