import { get } from '@antv/util';
import { isIntersect } from '../../../util/collision-detect';
import { getlLabelBackgroundInfo } from '../util';
/**
 * label 防遮挡布局：在不改变 label 位置的情况下对相互重叠的 label 进行隐藏（非移除）
 * 不同于 'overlap' 类型的布局，该布局不会对 label 的位置进行偏移调整。
 * @param labels 参与布局调整的 label 数组集合
 */
export function hideOverlap(items, labels, shapes, region) {
    // todo 添加 labelrank
    // each label will hide the next one because the next one always has lower rank.
    // Detect overlapping labels
    for (var i = 0; i < labels.length; i++) {
        var label1 = labels[i];
        if (labels[i].get('visible')) {
            for (var j = i + 1; j < labels.length; j++) {
                var label2 = labels[j];
                if (label1 && label2 && label1 !== label2 && label2.get('visible')) {
                    var box1 = getlLabelBackgroundInfo(label1, items[i], get(items[i], 'background.padding'));
                    var box2 = getlLabelBackgroundInfo(label2, items[j], get(items[j], 'background.padding'));
                    if (isIntersect(box1, box2)) {
                        labels[j].set('visible', false);
                    }
                }
            }
        }
    }
}
//# sourceMappingURL=hide-overlap.js.map