## 校验框架
系统使用[VeeValidate](https://baianat.github.io/vee-validate/)作为校验框架，校验的配置及提示信息已经集成到Ui的组件中，可以很方便的使用校验规则。

## 校验规则
|规则|校验内容|参数|校验表达式|说明|
|:-------|:------|:-------|:-------|:-------|
|confirmed|相同的值&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|一个参数，要校验当前字段和另外一个字段的值相同时，需要指定另外一个字段的model属性|:validate="'confirmed:'+data.cpwd"|另一个控件的代码为：`<ht-input type="password" v-model="data.cpwd"/>`|
|email|电子邮箱|-|validate="email"|-|
|regex|正则表达式|两个参数，第一个参数为正则表达式，第二个参数为校验未通过时的提示信息|validate="regex:^[0-9]+$,校验失败"|注意输入的正则表达式不能是`/^[0-9]+$/`格式，我们在解析校验规则时，会通过`newRegExp(args[0])`的方式来生成正则表达式对象。<br/>注意:字符串格式的表达式以英文逗号`,`来分割参数，如果正则表达式或者提示信息中包含了英文逗号，会导致校验规则的解析错误。这种情况下，我们需要按照Object格式来编写校验表达式`:validate="{regex:{exp:'^[0-9]+$',message:'校验失败，请输入数字。'}}"`|
|min|最小文本长度|一个数字类型的参数，指定文本的最小长度|validate="min:3"|-|
|min_value|最小数值|一个数字类型的参数，指定输入数字的最小值|validate="min_value:255"|-|
|max|最大文本长度|一个数字类型的参数，指定文本的最大长度|validate="max:3"|-|
|max_value|最大数值|一个数字类型的参数，指定输入数字的最大值|validate="max_value:255"|-|
|isAfter|日期晚于|一个参数，要对比的另外一个字段的model属性|:validate="'isAfter:'+startTime"|-|
|isBefore|日期早于|一个参数，要对比的另外一个字段的model属性|:validate="'isBefore:'+endTime"|另外一个字段的代码`<ht-datev-model="endTime"/>`|
|isStart|日期不早于|一个参数，要对比的另外一个字段的model属性|:validate="'isStart:'+new Date().format('yyyy-MM-dd')"|-|
|isEnd|日期不晚于|一个参数，要对比的另外一个字段的model属性|:validate="'isEnd:'+new Date().format('yyyy-MM-dd')"|-|
|numeric|整数|-|validate="numeric"|-|
|between|指定范围的数字(包含最小/大值)|两个参数，最小值/最大值，均为数字|validate="between:1,10"|-|
|is|指定的值|一个参数，指定的值|validate="is:test"|如`"is:test"`这样的表达式，则要求输入框的内容必须为`test`|
|digits|指定位数的数字|一个数字类型的参数，指定数字的位数|validate="digits:3"|-|
|mobile|手机号码|-|validate="mobile"|-|
|required|必填|-|validate="required"|-|
|alpha_spaces|字母空格|-|validate="alpha_spaces"|-|
|alpha_dash|字母数字横线下划线|-|validate="alpha_dash"|-|
|alpha_num|字母数字|-|validate="alpha_num"|-|
|alpha|字母|-|validate="alpha"|-|
|method|JS方法校|两个参数，第一个参数为要校验的JS方法，第二个参数为未通过校验时的提示信息|:validate="{method:{callback:callback,message:'校验失败'}}"|JS方法校验的表达式只能以Object格式，callback的示例代码如下：`callback:(value,args)=>{returnvalue=="test"}`，如果要在JS方法中异步调用接口来完成校验，则可以返回Promise对象，再通过Resolve来返回校验结果，如下所示：```callback:(value,args)=>{returnnewPromise(resolve=>{setTimeout(()=>{resolve(!!value);},300);});}```|

## 多个校验规则
使用字符串格式时，多个校验规则之间用管道符`|`分割，例如：`required|min:5|max:10`，而且在进行校验时，会按照从左至右的顺序依次校验。

使用对象格式时，多个校验规则格式如下：`{required: true, min: '5', max: '10'}`，注意：对象格式的校验规则，在校验时是无序的。

## 表单校验

在使用表单录入数据时，需要对表单中的所有校验字段进行校验，通过校验后才允许提交数据。代码示例如下：
```html
<template>
<form data-vv-scope="form1" v-form>
...
</form>
<script>
import utils from "@/utils.js";

export default {
    data(){
        return {
            data: {},
            loading: false
        };
    },
    methods: {
        submit: function() {
            this.loading = true;
            setTimeout(() => {
                utils
                .validateForm(this, "form1")
                .then(r => {
                    Message.success(JSON.stringify(this.data));
                })
                .catch(reason => {
                    Message.error(reason);
                })
                .finally(() => {
                    this.loading = false;
                });
            }, 500);
        }
    }
}
</script>
```
使用`data-vv-scope="form1"`来标记当前表单，在进行表单校验时，可以指定`form1`来验证指定作用域内的校验结果，避免同一个页面中具有多个表单时交叉校验的问题。另外`v-form`指令用于标记当前表单，实现表单内的数学计算时多个字段相互计算的需求。


# 参考代码

```html
<template>
  <el-tabs v-model="activeName">
    <el-tab-pane label="演示效果" name="demo">
      <form data-vv-scope="form1" v-form name="online-form">
        <table class="form-table" cellspacing="0" cellpadding="0" border="0">
          <tbody>
            <tr>
              <th class="group-th" colspan="4">基础表单</th>
            </tr>
            <tr v-permit="4">
              <th width="10%">密码：</th>
              <td width="40%">
                <ht-input
                  v-model="data.bo.password"
                  :validate="'required'"
                  type="password"
                  placeholder="请输入密码"
                />
              </td>
              <th width="10%">确认密码：</th>
              <td width="40%">
                <ht-input
                  v-model="data.bo.confirmPwd"
                  :validate="'required|confirmed:'+data.bo.password"
                  type="password"
                  placeholder="请输入确认密码"
                />
              </td>
            </tr>
            <tr v-permit="4">
              <th width="10%">出生日期：</th>
              <td>
                <ht-date
                  v-model="data.bo.csrq"
                  :validate="{'required':true,'isEnd': data.bo.bysj}"
                  format="yyyy-MM-dd"
                  value-format="yyyy-MM-dd"
                  :showDate="true"
                  :day="-3"
                />
              </td>
              <th>毕业时间：</th>
              <td>
                <ht-date
                  v-model="data.bo.bysj"
                  name="bysj"
                  format="yyyy-MM-dd"
                  value-format="yyyy-MM-dd"
                  :validate="{'required':true,'isBefore': new Date().format('yyyy-MM-dd')}"
                />
              </td>
            </tr>
            <tr v-permit="4">
              <th width="10%">isBefore：</th>
              <td>
                <ht-date
                  v-model="data.bo.isBefore"
                  :validate="{'required':true,'isBefore': new Date().format('yyyy-MM-dd')}"
                  format="yyyy-MM-dd"
                  value-format="yyyy-MM-dd"
                />
              </td>
              <th>isAfter：</th>
              <td>
                <ht-date
                  v-model="data.bo.isAfter"
                  format="yyyy-MM-dd hh:mm:ss"
                  value-format="yyyy-MM-dd hh:mm:ss"
                  :validate="{'required':true,'isAfter': new Date().format('yyyy-MM-dd hh:mm:ss')}"
                />
              </td>
            </tr>
          </tbody>
        </table>
        <pre>{{data.bo}}</pre>
      </form>
    </el-tab-pane>
    <el-tab-pane label="api文档" name="api">
      <MdView url="md/validation.md" />
    </el-tab-pane>
  </el-tabs>
</template>
<script>
import MdView from "@/views/MdView.vue";

export default {
  components: { MdView },
  data() {
    return {
      activeName: "demo",
      data: {
        bo: {
          password: "",
          confirmPwd: "",
          csrq:null,
          bysj:null,
          isBefore: null,
          isAfter: null
        }
      }
    };
  }
};
</script>
```