## 数学计算公式
如下所示，通过属性`math-exp`可以配置数学计算公式，通过表达式`{数字1(data.math1)}`即可找到`v-model="data.math1"`字段的值参与计算。


<span style="color:#f00;font-weight:bold">特别注意：</span>
+ 参与计算的字段需要包含在一个作用域中，而且用`v-form`指令声明为一个域。
- `math-exp`表达式只在`ht-input`控件上生效。

```html
<div v-form>
    <ht-input v-model="data.math1" placeholder="数字1" />
    <ht-input v-model="data.math2" placeholder="数字2" />
    <ht-input v-model="data.math3" disabled placeholder="数字1 + 数字2"
            math-exp="{数字1(data.math1)} + {数字2(data.math2)}" />
</div>
```
以表达式为对象，支持通过`+,-,*,/`等运算符对多个对象进行运算，另外我们还扩展了一些运算符。
|运算符|说明|示例|
|:--------|:--------|:--------|
|FormMath.abs(X)|取绝对值|`FormMath.abs({数字1(data.math1)} - {数字2(data.math2)})`|
|FormMath.round(X)|四舍五入为整数|`FormMath.round(3.1415)`结果为`3`|
|FormMath.ceil(X)|上舍入为整数（返回等于或大于X的整数）|`FormMath.ceil(3.1415)`结果为`4`|
|FormMath.floor(X)|下舍入为整数（返回等于或小于X的整数）|`FormMath.ceil(1.618)`结果为`1`|
|FormMath.max([...])|返回集合中的最大数|`FormMath.max([1,2,3,4,5,6])`结果为`6`|
|FormMath.min([...])|返回集合中的最小数|`FormMath.min([1,2,3,4,5,6])`结果为`1`|
|FormMath.sqrt(X)|返回X的平方根|`FormMath.sqrt(4)`结果为`2`|
|FormMath.average([...])|返回集合的平均值|`FormMath.average([1,2,3,4,5])`结果为`3`|
|FormMath.sum([...])|返回集合的和|`FormMath.sum([1,2,3,4,5])`的结果为`15`|
|FormMath.tofixed(X, Y)|返回保留小数点后Y位的X的四舍五入值|`FormMath.tofixed(3.14159265, 2)`的结果为`3.14`|
|FormMath.convertCurrency(X)|将数字转换为人民币大写|`FormMath.convertCurrency(123.45)`的结果为`壹佰贰拾叁元肆角伍分`|

## 子表中的运算
如下面的代码所示，需要对子表中的某列求和时，可以通过表达式`math-exp="FormMath.sum([{小计(data.sub.xj)}])"`来完成求和运算。


<span style="color:#f00;font-weight:bold">特别注意：</span>
+ 子表中的每行数据需要配置两个属性`:data-index="index"`和`data-subname="data.sub"`前者为当前行的索引，后者为子表对象在当前数据中对应的路径。
- 求和的表达式中`[{小计(data.sub.xj)]`以数组包含对象的方式指向子表某一列，`data.sub.xj`中`data.sub`为数组对象，但是`sub`后面不需要添加`[i]`作为索引。
```html
<ul class="math-ul">
    <li
    v-for="(row, index) in data.sub"
    :key="index"
    :data-index="index"
    data-subname="data.sub"
    >
    <div class="flex">
        <ht-input class="m-r" v-model="row.dj" placeholder="单价" />
        <ht-input class="m-r" v-model="row.sl" placeholder="数量" />
        <ht-input
        class="m-r"
        v-model="row.xj"
        placeholder="小计"
        math-exp="{单价(row.dj)} * {数量(row.sl)}"
        />
    </div>
    </li>
    <li>
    <ht-input
        class="m-r"
        v-model="data.math4"
        placeholder="对子表中的小计求和"
        math-exp="FormMath.sum([{小计(data.sub.xj)}])"
        />
    </li>
</ul>
```