/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceQueryController;
import org.jetlinks.community.rule.engine.alarm.AlarmHandleInfo;
import org.jetlinks.community.rule.engine.entity.AlarmHandleHistoryEntity;
import org.jetlinks.community.rule.engine.entity.AlarmRecordEntity;
import org.jetlinks.community.rule.engine.service.AlarmConfigService;
import org.jetlinks.community.rule.engine.service.AlarmHandleHistoryService;
import org.jetlinks.community.rule.engine.service.AlarmRecordService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/alarm/record"})
@Resource(id="alarm-record", name="\u544a\u8b66\u8bb0\u5f55")
@Authorize
@Tag(name="\u544a\u8b66\u8bb0\u5f55")
public class AlarmRecordController
implements ReactiveServiceQueryController<AlarmRecordEntity, String> {
    private final AlarmRecordService recordService;
    private final AlarmConfigService configService;
    private final AlarmHandleHistoryService handleHistoryService;

    public ReactiveCrudService<AlarmRecordEntity, String> getService() {
        return this.recordService;
    }

    @PostMapping(value={"/_handle"})
    @Operation(summary="\u5904\u7406\u544a\u8b66")
    @SaveAction
    public Mono<Void> handleAlarm(@RequestBody Mono<AlarmHandleInfo> handleInfo) {
        return handleInfo.flatMap(this.configService::handleAlarm);
    }

    @PostMapping(value={"/handle-history/_query"})
    @Operation(summary="\u544a\u8b66\u5904\u7406\u5386\u53f2\u67e5\u8be2")
    @QueryAction
    public Mono<PagerResult<AlarmHandleHistoryEntity>> queryHandleHistoryPager(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(arg_0 -> ((AlarmHandleHistoryService)this.handleHistoryService).queryPager(arg_0));
    }

    public AlarmRecordController(AlarmRecordService recordService, AlarmConfigService configService, AlarmHandleHistoryService handleHistoryService) {
        this.recordService = recordService;
        this.configService = configService;
        this.handleHistoryService = handleHistoryService;
    }
}

