/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.service;

import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.jetlinks.community.elastic.search.index.ElasticIndex;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.rule.engine.entity.RuleEngineExecuteEventInfo;
import org.jetlinks.community.rule.engine.entity.RuleEngineExecuteLogInfo;
import org.jetlinks.community.rule.engine.entity.RuleInstanceEntity;
import org.jetlinks.community.rule.engine.enums.RuleInstanceState;
import org.jetlinks.community.rule.engine.event.handler.RuleEngineLoggerIndexProvider;
import org.jetlinks.rule.engine.api.RuleEngine;
import org.jetlinks.rule.engine.api.model.RuleEngineModelParser;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class RuleInstanceService
extends GenericReactiveCrudService<RuleInstanceEntity, String>
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(RuleInstanceService.class);
    @Autowired
    private RuleEngine ruleEngine;
    @Autowired
    private RuleEngineModelParser modelParser;
    @Autowired
    private ElasticSearchService elasticSearchService;

    public Mono<PagerResult<RuleEngineExecuteEventInfo>> queryExecuteEvent(QueryParam queryParam) {
        return this.elasticSearchService.queryPager((ElasticIndex)RuleEngineLoggerIndexProvider.RULE_EVENT_LOG, queryParam, RuleEngineExecuteEventInfo.class);
    }

    public Mono<PagerResult<RuleEngineExecuteLogInfo>> queryExecuteLog(QueryParam queryParam) {
        return this.elasticSearchService.queryPager((ElasticIndex)RuleEngineLoggerIndexProvider.RULE_LOG, queryParam, RuleEngineExecuteLogInfo.class);
    }

    @Transactional
    public Mono<Void> stop(String id) {
        return this.ruleEngine.shutdown(id).then(((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(RuleInstanceEntity::getState, (Object)RuleInstanceState.disable)).where(RuleInstanceEntity::getId, (Object)id)).execute()).then();
    }

    @Transactional
    public Mono<Void> start(String id) {
        return this.findById(Mono.just((Object)id)).flatMap(this::doStart);
    }

    private Mono<Void> doStart(RuleInstanceEntity entity) {
        return Mono.defer(() -> {
            RuleModel model = entity.toRule(this.modelParser);
            return this.ruleEngine.startRule(entity.getId(), model).then(((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(RuleInstanceEntity::getState, (Object)RuleInstanceState.started)).where(entity::getId)).execute()).then();
        });
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return (Mono)Flux.from(idPublisher).flatMap(id -> this.stop((String)id).thenReturn(id)).as(x$0 -> super.deleteById(x$0));
    }

    public void run(String ... args) {
        ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).is(RuleInstanceEntity::getState, (Object)RuleInstanceState.started)).fetch().flatMap(e -> this.doStart((RuleInstanceEntity)((Object)e)).onErrorResume(err -> {
            log.warn("\u542f\u52a8\u89c4\u5219[{}]\u5931\u8d25", (Object)e.getName(), (Object)e);
            return Mono.empty();
        })).subscribe();
    }
}

