/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.service;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.elastic.search.index.DefaultElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.rule.engine.entity.AlarmHistoryInfo;
import org.jetlinks.community.rule.engine.service.AlarmHistoryService;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ElasticSearchAlarmHistoryService
implements AlarmHistoryService {
    public static final String ALARM_HISTORY_INDEX = "alarm_history";
    private final ElasticSearchIndexManager indexManager;
    private final ElasticSearchService elasticSearchService;

    @Override
    public Mono<PagerResult<AlarmHistoryInfo>> queryPager(QueryParam queryParam) {
        return this.elasticSearchService.queryPager(ALARM_HISTORY_INDEX, queryParam, AlarmHistoryInfo.class);
    }

    @Override
    public Mono<Void> save(AlarmHistoryInfo historyInfo) {
        return this.elasticSearchService.commit(ALARM_HISTORY_INDEX, this.createData(historyInfo));
    }

    @Override
    public Mono<Void> save(Flux<AlarmHistoryInfo> historyInfo) {
        return this.elasticSearchService.save(ALARM_HISTORY_INDEX, (Publisher)historyInfo.map(this::createData));
    }

    @Override
    public Mono<Void> save(Mono<AlarmHistoryInfo> historyInfo) {
        return this.elasticSearchService.save(ALARM_HISTORY_INDEX, (Publisher)historyInfo.map(this::createData));
    }

    private Map<String, Object> createData(AlarmHistoryInfo info) {
        return (Map)FastBeanCopier.copy((Object)info, new HashMap(16), (String[])new String[0]);
    }

    public void init() {
        this.indexManager.putIndex((ElasticSearchIndexMetadata)new DefaultElasticSearchIndexMetadata(ALARM_HISTORY_INDEX).addProperty("id", (DataType)StringType.GLOBAL).addProperty("alarmConfigId", (DataType)StringType.GLOBAL).addProperty("alarmConfigName", (DataType)StringType.GLOBAL).addProperty("alarmRecordId", (DataType)StringType.GLOBAL).addProperty("level", (DataType)IntType.GLOBAL).addProperty("description", (DataType)StringType.GLOBAL).addProperty("alarmTime", (DataType)DateTimeType.GLOBAL).addProperty("targetType", (DataType)StringType.GLOBAL).addProperty("targetName", (DataType)StringType.GLOBAL).addProperty("targetId", (DataType)StringType.GLOBAL).addProperty("sourceType", (DataType)StringType.GLOBAL).addProperty("sourceName", (DataType)StringType.GLOBAL).addProperty("sourceId", (DataType)StringType.GLOBAL).addProperty("alarmInfo", (DataType)StringType.GLOBAL).addProperty("creatorId", (DataType)StringType.GLOBAL).addProperty("bindings", (DataType)new ArrayType().elementType((DataType)StringType.GLOBAL))).block(Duration.ofSeconds(10L));
    }

    public ElasticSearchAlarmHistoryService(ElasticSearchIndexManager indexManager, ElasticSearchService elasticSearchService) {
        this.indexManager = indexManager;
        this.elasticSearchService = elasticSearchService;
    }
}

