/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.alarm;

import java.util.Map;
import java.util.Optional;
import org.jetlinks.community.rule.engine.alarm.AlarmData;
import org.jetlinks.community.rule.engine.alarm.AlarmTarget;
import org.jetlinks.community.rule.engine.alarm.AlarmTargetInfo;
import reactor.core.publisher.Flux;

public abstract class AbstractAlarmTarget
implements AlarmTarget {
    @Override
    public final Flux<AlarmTargetInfo> convert(AlarmData data) {
        return this.doConvert(data).doOnNext(info -> {
            String sourceType = AbstractAlarmTarget.getFromOutput("sourceType", data.getOutput()).map(String::valueOf).orElse(null);
            String sourceId = AbstractAlarmTarget.getFromOutput("sourceId", data.getOutput()).map(String::valueOf).orElse(null);
            String sourceName = AbstractAlarmTarget.getFromOutput("sourceName", data.getOutput()).map(String::valueOf).orElse(sourceId);
            if (sourceType != null && sourceId != null) {
                info.withSource(sourceType, sourceId, sourceName);
            }
        });
    }

    protected abstract Flux<AlarmTargetInfo> doConvert(AlarmData var1);

    static Optional<Object> getFromOutput(String key, Map<String, Object> output) {
        Object sceneOutput = output.get("scene");
        if (sceneOutput instanceof Map) {
            return Optional.ofNullable(((Map)sceneOutput).get(key));
        }
        return Optional.ofNullable(output.get(key));
    }
}

