/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.jetlinks.community.notify.manager.entity.NotificationEntity;
import org.jetlinks.community.notify.manager.entity.NotifySubscriberEntity;
import org.jetlinks.community.notify.manager.enums.NotificationState;
import org.jetlinks.community.notify.manager.enums.SubscribeState;
import org.jetlinks.community.notify.manager.service.NotificationService;
import org.jetlinks.community.notify.manager.service.NotifySubscriberService;
import org.jetlinks.community.notify.manager.subscriber.SubscriberProvider;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/notifications"})
@Tag(name="\u7cfb\u7edf\u901a\u77e5\u7ba1\u7406")
public class NotificationController {
    private final NotificationService notificationService;
    private final NotifySubscriberService subscriberService;
    private final List<SubscriberProvider> providers;

    public NotificationController(NotificationService notificationService, NotifySubscriberService subscriberService, List<SubscriberProvider> providers) {
        this.notificationService = notificationService;
        this.subscriberService = subscriberService;
        this.providers = providers;
    }

    @GetMapping(value={"/subscriptions/_query"})
    @Authorize(ignore=true)
    @QueryOperation(summary="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u8ba2\u9605\u4fe1\u606f")
    public Mono<PagerResult<NotifySubscriberEntity>> querySubscription(@Parameter(hidden=true) QueryParamEntity query) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> (Mono)query.toNestQuery(q -> {
            Query cfr_ignored_0 = (Query)((Query)q.where(NotifySubscriberEntity::getSubscriberType, (Object)"user")).and(NotifySubscriberEntity::getSubscriber, (Object)auth.getUser().getId());
        }).execute(arg_0 -> ((NotifySubscriberService)this.subscriberService).queryPager(arg_0)));
    }

    @PostMapping(value={"/subscriptions/_query"})
    @Authorize(ignore=true)
    @Operation(summary="POST\u67e5\u8be2\u5f53\u524d\u7528\u6237\u8ba2\u9605\u4fe1\u606f")
    public Mono<PagerResult<NotifySubscriberEntity>> querySubscription(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(this::querySubscription);
    }

    @PutMapping(value={"/subscription/{id}/_{state}"})
    @Authorize(ignore=true)
    @Operation(summary="\u4fee\u6539\u901a\u77e5\u8ba2\u9605\u72b6\u6001")
    public Mono<Void> changeSubscribeState(@PathVariable String id, @PathVariable SubscribeState state) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.subscriberService.createUpdate().set(NotifySubscriberEntity::getState, (Object)state)).where(GenericEntity::getId, (Object)id)).and(NotifySubscriberEntity::getSubscriber, (Object)auth.getUser().getId())).and(NotifySubscriberEntity::getSubscriberType, (Object)"user")).execute().then());
    }

    @DeleteMapping(value={"/subscription/{id}"})
    @Authorize(ignore=true)
    @Operation(summary="\u5220\u9664\u8ba2\u9605")
    public Mono<Void> deleteSubscription(@PathVariable String id) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)this.subscriberService.createDelete().where(GenericEntity::getId, (Object)id)).and(NotifySubscriberEntity::getSubscriber, (Object)auth.getUser().getId())).and(NotifySubscriberEntity::getSubscriberType, (Object)"user")).execute().then());
    }

    @PatchMapping(value={"/subscribe"})
    @Authorize(ignore=true)
    @Operation(summary="\u8ba2\u9605\u901a\u77e5")
    public Mono<NotifySubscriberEntity> doSubscribe(@RequestBody Mono<NotifySubscriberEntity> subscribe) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> subscribe.doOnNext(e -> {
            e.setSubscriberType("user");
            e.setSubscriber(auth.getUser().getId());
        }).flatMap(e -> this.subscriberService.doSubscribe((NotifySubscriberEntity)((Object)((Object)e))).thenReturn((Object)e)));
    }

    @GetMapping(value={"/providers"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u8ba2\u9605\u652f\u6301")
    public Flux<SubscriberProviderInfo> getProviders() {
        return Flux.fromIterable(this.providers).map(SubscriberProviderInfo::of);
    }

    @GetMapping(value={"/_query"})
    @Authorize(ignore=true)
    @QueryOperation(summary="\u67e5\u8be2\u901a\u77e5\u8bb0\u5f55")
    public Mono<PagerResult<NotificationEntity>> queryMyNotifications(@Parameter(hidden=true) QueryParamEntity query) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> ((Mono)query.toNestQuery(q -> {
            Query cfr_ignored_0 = (Query)((Query)q.where(NotificationEntity::getSubscriberType, (Object)"user")).and(NotificationEntity::getSubscriber, (Object)auth.getUser().getId());
        }).execute(arg_0 -> ((NotificationService)this.notificationService).queryPager(arg_0))).defaultIfEmpty((Object)PagerResult.empty()));
    }

    @PostMapping(value={"/_query"})
    @Authorize(ignore=true)
    @Operation(summary="\u4f7f\u7528POST\u65b9\u5f0f\u67e5\u8be2\u901a\u77e5\u8bb0\u5f55")
    public Mono<PagerResult<NotificationEntity>> queryMyNotifications(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(this::queryMyNotifications);
    }

    @GetMapping(value={"/{id}/read"})
    @Authorize(ignore=true)
    @QueryOperation(summary="\u83b7\u53d6\u901a\u77e5\u8bb0\u5f55")
    public Mono<NotificationEntity> readNotification(@PathVariable String id) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> ((Flux)((Query)((Query)((Query)QueryParamEntity.newQuery().where(NotificationEntity::getSubscriberType, (Object)"user")).and(NotificationEntity::getSubscriber, (Object)auth.getUser().getId())).and(GenericEntity::getId, (Object)id)).execute(this.notificationService::findAndMarkRead)).singleOrEmpty());
    }

    @PostMapping(value={"/_{state}"})
    @Authorize(ignore=true)
    @QueryOperation(summary="\u4fee\u6539\u901a\u77e5\u72b6\u6001")
    public Mono<Integer> readNotification(@RequestBody Mono<List<String>> idList, @PathVariable NotificationState state) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> idList.filter(CollectionUtils::isNotEmpty).flatMap(list -> ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.notificationService.createUpdate().set(NotificationEntity::getState, (Object)state)).where(NotificationEntity::getSubscriberType, (Object)"user")).and(NotificationEntity::getSubscriber, (Object)auth.getUser().getId())).in(GenericEntity::getId, (Collection)list)).execute()));
    }

    public static class SubscriberProviderInfo {
        private String id;
        private String name;
        private ConfigMetadata metadata;

        public static SubscriberProviderInfo of(SubscriberProvider provider) {
            SubscriberProviderInfo info = new SubscriberProviderInfo();
            info.id = provider.getId();
            info.name = provider.getName();
            info.setMetadata(provider.getConfigMetadata());
            return info;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ConfigMetadata getMetadata() {
            return this.metadata;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMetadata(ConfigMetadata metadata) {
            this.metadata = metadata;
        }
    }
}

