/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.VariableDefinition;

@Table(name="notify_template")
@Comment(value="\u6d88\u606f\u901a\u77e5\u6a21\u677f\u8868")
@EnableEntityEvent
public class NotifyTemplateEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    private static final long serialVersionUID = -6849794470754667710L;
    @Column
    @Schema(description="\u901a\u77e5\u7c7b\u578bID")
    @NotBlank(groups={CreateGroup.class})
    private String type;
    @Column
    @Schema(description="\u901a\u77e5\u670d\u52a1\u5546ID")
    @NotBlank(groups={CreateGroup.class})
    private String provider;
    @Column
    @Schema(description="\u6a21\u7248\u540d\u79f0")
    private String name;
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    @JsonCodec
    @Schema(description="\u6a21\u7248\u5185\u5bb9(\u6839\u636e\u670d\u52a1\u5546\u4e0d\u540c\u800c\u4e0d\u540c)")
    private Map<String, Object> template;
    @Column(updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    @JsonCodec
    @Schema(description="\u53d8\u91cf\u5b9a\u4e49")
    private List<VariableDefinition> variableDefinitions;
    @Column(length=64)
    @Schema(description="\u901a\u77e5\u914d\u7f6eID")
    private String configId;
    @Column
    @Schema(description="\u8bf4\u660e")
    private String description;

    @GeneratedValue(generator="snow_flake")
    @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", groups={CreateGroup.class})
    @Schema(description="\u6a21\u677fID(\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210)")
    public @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", groups={CreateGroup.class}) String getId() {
        return (String)super.getId();
    }

    public TemplateProperties toTemplateProperties() {
        TemplateProperties properties = new TemplateProperties();
        properties.setId(this.getId());
        properties.setProvider(this.provider);
        properties.setType(this.type);
        properties.setConfigId(this.configId);
        properties.setName(this.name);
        properties.setTemplate(this.template);
        properties.setVariableDefinitions(this.variableDefinitions);
        properties.setDescription(this.description);
        return properties;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTemplate(Map<String, Object> template) {
        this.template = template;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setVariableDefinitions(List<VariableDefinition> variableDefinitions) {
        this.variableDefinitions = variableDefinitions;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getTemplate() {
        return this.template;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getDescription() {
        return this.description;
    }
}

