/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.entity;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.notify.NotifierProperties;

@Table(name="notify_config")
@Comment(value="\u6d88\u606f\u901a\u77e5\u914d\u7f6e\u8868")
@EnableEntityEvent
public class NotifyConfigEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    private static final long serialVersionUID = -6849794470754667710L;
    @Column
    @Schema(description="\u914d\u7f6e\u540d\u79f0")
    @NotBlank(groups={CreateGroup.class})
    private String name;
    @Column
    @Schema(description="\u901a\u77e5\u7c7b\u578b")
    @NotBlank(groups={CreateGroup.class})
    private String type;
    @Column
    @Schema(description="\u670d\u52a1\u63d0\u4f9b\u5546")
    @NotBlank(groups={CreateGroup.class})
    private String provider;
    @Column
    @Schema(description="\u63cf\u8ff0")
    private String description;
    @Column(length=512)
    @JsonCodec
    @ColumnType(javaType=String.class)
    @Schema(description="\u91cd\u8bd5\u7b56\u7565,\u5982: [\"1s\",\"20s\",\"5m\",\"15m\"]")
    @Hidden
    private List<String> retryPolicy;
    @Column
    @DefaultValue(value="0")
    @Schema(description="\u6700\u5927\u91cd\u8bd5\u6b21\u6570")
    @Hidden
    private Integer maxRetryTimes;
    @Column(updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.CLOB)
    @Schema(description="\u914d\u7f6e\u4fe1\u606f")
    private Map<String, Object> configuration;

    @GeneratedValue(generator="snow_flake")
    @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", groups={CreateGroup.class})
    @Schema(description="\u8bbe\u5907ID(\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210)")
    public @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", groups={CreateGroup.class}) String getId() {
        return (String)super.getId();
    }

    public NotifierProperties toProperties() {
        NotifierProperties properties = new NotifierProperties();
        properties.setProvider(this.provider);
        properties.setId(this.getId());
        properties.setType(this.type);
        properties.setConfiguration(this.configuration == null ? new HashMap() : this.configuration);
        properties.setName(this.name);
        return properties;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getRetryPolicy() {
        return this.retryPolicy;
    }

    public Integer getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRetryPolicy(List<String> retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setMaxRetryTimes(Integer maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }
}

