/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.rule.engine.executor.PayloadType;
import org.reactivestreams.Publisher;

public class ProtocolEncodePayload {
    private DefaultTransport transport;
    private String payload;
    private PayloadType payloadType = PayloadType.STRING;

    public Message toDeviceMessage() {
        return (Message)MessageType.convertMessage((Map)JSON.parseObject((String)this.payload)).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u6d88\u606f"));
    }

    public Publisher<Object> doEncode(ProtocolSupport support, final DeviceOperator operator) {
        return support.getMessageCodec((Transport)this.getTransport()).flatMapMany(codec -> codec.encode(new MessageEncodeContext(){

            public Message getMessage() {
                return ProtocolEncodePayload.this.toDeviceMessage();
            }

            @Nullable
            public DeviceOperator getDevice() {
                return operator;
            }
        })).map(msg -> {
            if (msg instanceof MqttMessage) {
                JSONObject obj = (JSONObject)JSON.toJSON((Object)msg);
                obj.put("payload", this.payloadType.read(msg.getPayload()));
                obj.remove((Object)"bytes");
                return obj;
            }
            return this.getPayloadType().read(msg.getPayload());
        });
    }

    public DefaultTransport getTransport() {
        return this.transport;
    }

    public String getPayload() {
        return this.payload;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public void setTransport(DefaultTransport transport) {
        this.transport = transport;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }
}

