/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web.request;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DefaultCoapMessage;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.FromDeviceMessageContext;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.SimpleMqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.rule.engine.executor.PayloadType;
import org.reactivestreams.Publisher;

public class ProtocolDecodePayload {
    private DefaultTransport transport;
    private PayloadType payloadType = PayloadType.STRING;
    private String payload;

    public EncodedMessage toEncodedMessage() {
        if (this.transport == DefaultTransport.MQTT || this.transport == DefaultTransport.MQTT_TLS) {
            if (this.payload.startsWith("{")) {
                SimpleMqttMessage message = (SimpleMqttMessage)FastBeanCopier.copy((Object)JSON.parseObject((String)this.payload), (Object)new SimpleMqttMessage(), (String[])new String[0]);
                message.setPayloadType(MessagePayloadType.of((String)this.payloadType.getId()));
            }
            return SimpleMqttMessage.of((String)this.payload);
        }
        if (this.transport == DefaultTransport.CoAP || this.transport == DefaultTransport.CoAP_DTLS) {
            return DefaultCoapMessage.of((String)this.payload);
        }
        return EncodedMessage.simple((ByteBuf)this.payloadType.write((Object)this.payload));
    }

    public Publisher<? extends Message> doDecode(ProtocolSupport support, final DeviceOperator deviceOperator) {
        return support.getMessageCodec((Transport)this.getTransport()).flatMapMany(codec -> codec.decode((MessageDecodeContext)new FromDeviceMessageContext(){

            public EncodedMessage getMessage() {
                return ProtocolDecodePayload.this.toEncodedMessage();
            }

            public DeviceSession getSession() {
                return null;
            }

            @Nullable
            public DeviceOperator getDevice() {
                return deviceOperator;
            }
        }));
    }

    public DefaultTransport getTransport() {
        return this.transport;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setTransport(DefaultTransport transport) {
        this.transport = transport;
    }

    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }
}

