/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web.excel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.converter.RowWrapper;
import org.jetlinks.community.device.web.excel.DeviceExcelInfo;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;

public class DeviceWrapper
extends RowWrapper<DeviceExcelInfo> {
    Map<String, PropertyMetadata> tagMapping = new HashMap<String, PropertyMetadata>();
    Map<String, ConfigPropertyMetadata> configMapping = new HashMap<String, ConfigPropertyMetadata>();
    static Map<String, String> headerMapping = DeviceExcelInfo.getImportHeaderMapping();
    public static DeviceWrapper empty = new DeviceWrapper(Collections.emptyList(), Collections.emptyList());

    public DeviceWrapper(List<PropertyMetadata> tags, List<ConfigPropertyMetadata> configs) {
        for (PropertyMetadata tag : tags) {
            this.tagMapping.put(tag.getName(), tag);
        }
        for (ConfigPropertyMetadata config : configs) {
            this.configMapping.put(config.getName(), config);
        }
    }

    protected DeviceExcelInfo newInstance() {
        return new DeviceExcelInfo();
    }

    protected DeviceExcelInfo wrap(DeviceExcelInfo deviceExcelInfo, Cell header, Cell cell) {
        String headerText = header.valueAsText().orElse("null");
        PropertyMetadata maybeTag = this.tagMapping.get(headerText);
        ConfigPropertyMetadata maybeConfig = this.configMapping.get(headerText);
        if (maybeTag != null) {
            deviceExcelInfo.tag(maybeTag.getId(), headerText, cell.value().orElse(null), maybeTag.getValueType().getId());
        } else if (maybeConfig != null) {
            deviceExcelInfo.config(maybeConfig.getProperty(), cell.value().orElse(null));
        } else {
            deviceExcelInfo.with(headerMapping.getOrDefault(headerText, headerText), cell.value().orElse(null));
        }
        deviceExcelInfo.setRowNumber(cell.getRowIndex());
        return deviceExcelInfo;
    }
}

