/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web.excel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.hswebframework.reactor.excel.CellDataType;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.device.entity.DeviceTagEntity;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.springframework.util.StringUtils;

public class DeviceExcelInfo {
    @NotBlank(message="\u8bbe\u5907ID\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u8bbe\u5907ID\u4e0d\u80fd\u4e3a\u7a7a") String id;
    @NotBlank(message="\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String name;
    private String orgName;
    private String productName;
    private String parentId;
    private List<DeviceTagEntity> tags = new ArrayList<DeviceTagEntity>();
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private long rowNumber;
    private String state;

    public void config(String key, Object value) {
        if (value == null) {
            return;
        }
        this.configuration.put(key, value);
    }

    public void tag(String key, String name, Object value, String type) {
        if (value == null) {
            return;
        }
        DeviceTagEntity entity = new DeviceTagEntity();
        entity.setKey(key);
        entity.setValue(String.valueOf(value));
        entity.setName(name);
        entity.setDeviceId(this.id);
        entity.setType(type);
        entity.setId(DeviceTagEntity.createTagId(this.id, key));
        this.tags.add(entity);
    }

    public void setId(String id) {
        this.id = id;
        for (DeviceTagEntity tag : this.tags) {
            tag.setDeviceId(id);
            tag.setId(DeviceTagEntity.createTagId(tag.getDeviceId(), tag.getKey()));
        }
    }

    public void with(String key, Object value) {
        FastBeanCopier.copy(Collections.singletonMap(key, value), (Object)this, (String[])new String[0]);
    }

    public Map<String, Object> toMap() {
        Map val = (Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[0]);
        for (DeviceTagEntity tag : this.tags) {
            val.put(tag.getKey(), tag.getValue());
        }
        return val;
    }

    public static List<ExcelHeader> getTemplateHeaderMapping(List<PropertyMetadata> tags, List<ConfigPropertyMetadata> configs) {
        ArrayList<ExcelHeader> arr = new ArrayList<ExcelHeader>(Arrays.asList(new ExcelHeader("id", "\u8bbe\u5907ID", CellDataType.STRING), new ExcelHeader("name", "\u8bbe\u5907\u540d\u79f0", CellDataType.STRING), new ExcelHeader("orgName", "\u6240\u5c5e\u673a\u6784", CellDataType.STRING), new ExcelHeader("parentId", "\u7236\u8bbe\u5907ID", CellDataType.STRING)));
        for (PropertyMetadata tag : tags) {
            arr.add(new ExcelHeader(tag.getId(), StringUtils.isEmpty((Object)tag.getName()) ? tag.getId() : tag.getName(), CellDataType.STRING));
        }
        for (ConfigPropertyMetadata config : configs) {
            arr.add(new ExcelHeader("configuration." + config.getProperty(), StringUtils.isEmpty((Object)config.getName()) ? config.getProperty() : config.getName(), CellDataType.STRING));
        }
        return arr;
    }

    public static List<ExcelHeader> getExportHeaderMapping(List<PropertyMetadata> tags, List<ConfigPropertyMetadata> configs) {
        ArrayList<ExcelHeader> arr = new ArrayList<ExcelHeader>(Arrays.asList(new ExcelHeader("id", "\u8bbe\u5907ID", CellDataType.STRING), new ExcelHeader("name", "\u8bbe\u5907\u540d\u79f0", CellDataType.STRING), new ExcelHeader("productName", "\u8bbe\u5907\u578b\u53f7", CellDataType.STRING), new ExcelHeader("orgName", "\u6240\u5c5e\u673a\u6784", CellDataType.STRING), new ExcelHeader("parentId", "\u7236\u8bbe\u5907ID", CellDataType.STRING), new ExcelHeader("state", "\u72b6\u6001", CellDataType.STRING)));
        for (PropertyMetadata tag : tags) {
            arr.add(new ExcelHeader(tag.getId(), StringUtils.isEmpty((Object)tag.getName()) ? tag.getId() : tag.getName(), CellDataType.STRING));
        }
        for (ConfigPropertyMetadata config : configs) {
            arr.add(new ExcelHeader("configuration." + config.getProperty(), StringUtils.isEmpty((Object)config.getName()) ? config.getProperty() : config.getName(), CellDataType.STRING));
        }
        return arr;
    }

    public static Map<String, String> getImportHeaderMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("\u8bbe\u5907ID", "id");
        mapping.put("\u8bbe\u5907\u540d\u79f0", "name");
        mapping.put("\u540d\u79f0", "name");
        mapping.put("\u6240\u5c5e\u673a\u6784", "orgName");
        mapping.put("\u7236\u8bbe\u5907ID", "parentId");
        return mapping;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public List<DeviceTagEntity> getTags() {
        return this.tags;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public long getRowNumber() {
        return this.rowNumber;
    }

    public String getState() {
        return this.state;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setTags(List<DeviceTagEntity> tags) {
        this.tags = tags;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setRowNumber(long rowNumber) {
        this.rowNumber = rowNumber;
    }

    public void setState(String state) {
        this.state = state;
    }
}

