/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityEventHelper;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.exception.I18nSupportException;
import org.hswebframework.web.exception.TraceSourceException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.entity.DeviceProperty;
import org.jetlinks.community.device.entity.DeviceStateInfo;
import org.jetlinks.community.device.entity.DeviceTagEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.events.DeviceDeployedEvent;
import org.jetlinks.community.device.events.DeviceUnregisterEvent;
import org.jetlinks.community.device.response.DeviceDeployResult;
import org.jetlinks.community.device.response.DeviceDetail;
import org.jetlinks.community.device.service.DeviceConfigMetadataManager;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.community.relation.service.RelationService;
import org.jetlinks.community.relation.service.response.RelatedInfo;
import org.jetlinks.community.utils.ErrorUtils;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.FunctionInvokeMessageSender;
import org.jetlinks.core.message.ReadPropertyMessageSender;
import org.jetlinks.core.message.WritePropertyMessageSender;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.utils.CyclicDependencyChecker;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.reactive.TransactionalOperator;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Service
public class LocalDeviceInstanceService
extends GenericReactiveCrudService<DeviceInstanceEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(LocalDeviceInstanceService.class);
    private final DeviceRegistry registry;
    private final LocalDeviceProductService deviceProductService;
    private final ReactiveRepository<DeviceTagEntity, String> tagRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final DeviceConfigMetadataManager metadataManager;
    private final RelationService relationService;
    private final TransactionalOperator transactionalOperator;
    private final CyclicDependencyChecker<DeviceInstanceEntity, Void> checker = CyclicDependencyChecker.of(DeviceInstanceEntity::getId, DeviceInstanceEntity::getParentId, arg_0 -> ((LocalDeviceInstanceService)this).findById(arg_0));

    public LocalDeviceInstanceService(DeviceRegistry registry, LocalDeviceProductService deviceProductService, ReactiveRepository<DeviceTagEntity, String> tagRepository, ApplicationEventPublisher eventPublisher, DeviceConfigMetadataManager metadataManager, RelationService relationService, TransactionalOperator transactionalOperator) {
        this.registry = registry;
        this.deviceProductService = deviceProductService;
        this.tagRepository = tagRepository;
        this.eventPublisher = eventPublisher;
        this.metadataManager = metadataManager;
        this.relationService = relationService;
        this.transactionalOperator = transactionalOperator;
    }

    public Mono<SaveResult> save(Publisher<DeviceInstanceEntity> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).flatMap(instance -> {
            instance.setState(null);
            if (StringUtils.isEmpty((Object)instance.getId())) {
                return this.handleCreateBefore((DeviceInstanceEntity)((Object)instance));
            }
            return this.registry.getDevice(instance.getId()).flatMap(DeviceOperator::getState).map(DeviceState::of).onErrorReturn((Object)DeviceState.offline).defaultIfEmpty((Object)DeviceState.notActive).doOnNext(instance::setState).thenReturn((Object)instance);
        }).as(x$0 -> super.save(x$0));
    }

    public Mono<Map<String, Object>> resetConfiguration(String deviceId) {
        return this.findById(deviceId).zipWhen(device -> this.deviceProductService.findById(device.getProductId())).flatMap(tp2 -> {
            DeviceProductEntity product = (DeviceProductEntity)((Object)((Object)tp2.getT2()));
            DeviceInstanceEntity device = (DeviceInstanceEntity)((Object)((Object)tp2.getT1()));
            return Mono.defer(() -> {
                if (MapUtils.isNotEmpty(product.getConfiguration())) {
                    if (MapUtils.isNotEmpty(device.getConfiguration())) {
                        product.getConfiguration().keySet().forEach(device.getConfiguration()::remove);
                    }
                    return this.registry.getDevice(deviceId).flatMap(opts -> opts.removeConfigs(product.getConfiguration().keySet())).then();
                }
                return Mono.empty();
            }).then(Mono.defer(() -> ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().when(device.getConfiguration() != null, update -> {
                ReactiveUpdate cfr_ignored_0 = (ReactiveUpdate)update.set(device::getConfiguration);
            })).when(device.getConfiguration() == null, update -> {
                ReactiveUpdate cfr_ignored_0 = (ReactiveUpdate)update.setNull(DeviceInstanceEntity::getConfiguration);
            })).where(device::getId)).execute())).then(Mono.fromSupplier(device::getConfiguration));
        }).defaultIfEmpty(Collections.emptyMap());
    }

    public Mono<DeviceDeployResult> deploy(String id) {
        return ((Flux)this.findById(id).flux().as(flux -> this.deploy((Flux<DeviceInstanceEntity>)flux, Mono::error))).singleOrEmpty();
    }

    public Flux<DeviceDeployResult> deploy(Flux<DeviceInstanceEntity> flux) {
        return this.deploy(flux, err -> Mono.empty());
    }

    public Flux<DeviceDeployResult> deploy(Flux<DeviceInstanceEntity> flux, Function<Throwable, Mono<Void>> fallback) {
        ConcurrentHashMap rollback = new ConcurrentHashMap();
        return (Flux)flux.flatMap(device -> this.registry.getDevice(device.getId()).switchIfEmpty(Mono.fromRunnable(() -> rollback.put(device.getId(), this.registry.unregisterDevice(device.getId())))).thenReturn((Object)device)).flatMap(instance -> this.registry.register(instance.toDeviceInfo()).flatMap(deviceOperator -> deviceOperator.checkState().onErrorReturn((Object)-1).flatMap(r -> {
            if (r.equals((byte)0) || r.equals((byte)-3)) {
                instance.setState(DeviceState.offline);
                return deviceOperator.putState((byte)-1);
            }
            instance.setState(DeviceState.of(r));
            return Mono.just((Object)true);
        }).flatMap(success -> success != false ? Mono.just((Object)deviceOperator) : Mono.empty())).thenReturn((Object)instance).onErrorResume(e -> ((Mono)fallback.apply((Throwable)e)).then(Mono.empty()))).buffer(200).publishOn(Schedulers.single()).concatMap(all -> ((Flux)((Flux)Flux.fromIterable((Iterable)all).groupBy(DeviceInstanceEntity::getState).flatMap(group -> group.map(DeviceInstanceEntity::getId).collectList().flatMap(list -> ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().where()).set(DeviceInstanceEntity::getState, group.key())).set(DeviceInstanceEntity::getRegistryTime, (Object)System.currentTimeMillis())).in(DeviceInstanceEntity::getId, (Collection)list)).is(DeviceInstanceEntity::getState, (Object)DeviceState.notActive)).execute().map(r -> DeviceDeployResult.success(list.size())))).flatMap(res -> DeviceDeployedEvent.of(all).publish(this.eventPublisher).thenReturn(res)).as(LocaleUtils::transform)).as(arg_0 -> ((TransactionalOperator)this.transactionalOperator).transactional(arg_0))).onErrorResume(err -> Flux.fromIterable((Iterable)all).mapNotNull(device -> (Mono)rollback.get(device.getId())).flatMap(Function.identity()).then(Mono.zip((Mono)I18nSupportException.tryGetLocalizedMessageReactive((Throwable)err), (Mono)TraceSourceException.tryGetOperationLocalizedReactive((Throwable)err).defaultIfEmpty((Object)""), (msg, opt) -> new DeviceDeployResult(all.size(), false, (String)msg, TraceSourceException.tryGetSource((Throwable)err), (String)opt))).flatMap(res -> ((Mono)fallback.apply((Throwable)err)).thenReturn(res)))).as(EntityEventHelper::setDoNotFireEvent);
    }

    public Mono<Integer> unregisterDevice(String id) {
        return this.unregisterDevice((Publisher<String>)Mono.just((Object)id)).thenReturn((Object)1);
    }

    public Mono<Integer> unregisterDevice(Publisher<String> ids) {
        return (Mono)Flux.from(ids).buffer(200).flatMap(list -> this.findById((Collection)list).collectList().flatMap(devices -> DeviceUnregisterEvent.of(devices).publish(this.eventPublisher)).then(((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(DeviceInstanceEntity::getState, (Object)DeviceState.notActive.getValue())).where()).in(DeviceInstanceEntity::getId, (Collection)list)).execute().thenReturn(list))).flatMapIterable(Function.identity()).flatMap(id -> this.registry.getDevice(id).flatMap(DeviceOperator::disconnect).onErrorResume(err -> Mono.empty()).then(this.registry.unregisterDevice(id)).onErrorResume(err -> Mono.empty()).thenReturn(id)).count().map(Long::intValue).as(EntityEventHelper::setDoNotFireEvent);
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return Flux.from(idPublisher).collectList().flatMap(list -> ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)this.createDelete().where()).in(DeviceInstanceEntity::getId, (Collection)list)).and(DeviceInstanceEntity::getState, (Object)DeviceState.notActive)).execute());
    }

    private boolean hasContext(QueryParamEntity param, String key) {
        return param.getContext(key).map(CastUtils::castBoolean).orElse(true);
    }

    public Mono<PagerResult<DeviceDetail>> queryDeviceDetail(QueryParamEntity entity) {
        return this.queryPager(entity).filter(e -> CollectionUtils.isNotEmpty((Collection)e.getData())).flatMap(result -> this.convertDeviceInstanceToDetail(result.getData(), this.hasContext(entity, "includeTags"), this.hasContext(entity, "includeBind"), this.hasContext(entity, "includeRelations"), this.hasContext(entity, "includeFirmwareInfos")).collectList().map(detailList -> PagerResult.of((int)result.getTotal(), (List)detailList, (QueryParam)entity))).defaultIfEmpty((Object)PagerResult.empty());
    }

    public Flux<DeviceDetail> queryDeviceDetailList(QueryParamEntity entity) {
        return this.query(entity).collectList().flatMapMany(list -> this.convertDeviceInstanceToDetail((List<DeviceInstanceEntity>)list, this.hasContext(entity, "includeTags"), this.hasContext(entity, "includeBind"), this.hasContext(entity, "includeRelations"), this.hasContext(entity, "includeFirmwareInfos")));
    }

    private Mono<Map<String, List<DeviceTagEntity>>> queryDeviceTagGroup(Collection<String> deviceIdList) {
        return ((ReactiveQuery)((ReactiveQuery)this.tagRepository.createQuery().where()).in(DeviceTagEntity::getDeviceId, deviceIdList)).fetch().collect(Collectors.groupingBy(DeviceTagEntity::getDeviceId)).defaultIfEmpty(Collections.emptyMap());
    }

    private Flux<DeviceDetail> convertDeviceInstanceToDetail(List<DeviceInstanceEntity> instanceList, boolean includeTag, boolean includeBinds, boolean includeRelations, boolean includeFirmwareInfos) {
        if (CollectionUtils.isEmpty(instanceList)) {
            return Flux.empty();
        }
        ArrayList<String> deviceIdList = new ArrayList<String>(instanceList.size());
        Map<String, List<DeviceInstanceEntity>> productGroup = instanceList.stream().peek(device -> deviceIdList.add(device.getId())).collect(Collectors.groupingBy(DeviceInstanceEntity::getProductId));
        Mono<Map<String, List<DeviceTagEntity>>> tags = includeTag ? this.queryDeviceTagGroup(deviceIdList) : Mono.just(Collections.emptyMap());
        Mono relations = includeRelations ? this.relationService.getRelationInfo("device", deviceIdList).collect(Collectors.groupingBy(RelatedInfo::getObjectId)).defaultIfEmpty(Collections.emptyMap()) : Mono.just(Collections.emptyMap());
        return Mono.zip((Mono)this.deviceProductService.findById(productGroup.keySet()).collect(Collectors.toMap(DeviceProductEntity::getId, Function.identity())), tags, (Mono)relations).flatMapMany(tp5 -> Flux.fromIterable((Iterable)instanceList).flatMap(instance -> this.createDeviceDetail((DeviceInstanceEntity)((Object)((Object)instance)), (DeviceProductEntity)((Object)((Object)((Object)((Map)tp5.getT1()).get(instance.getProductId())))), (List)((Map)tp5.getT2()).get(instance.getId()), (List)((Map)tp5.getT3()).get(instance.getId())))).sort(Comparator.comparingInt(detail -> deviceIdList.indexOf(detail.getId())));
    }

    private Mono<DeviceDetail> createDeviceDetail(DeviceInstanceEntity device, DeviceProductEntity product, List<DeviceTagEntity> tags, List<RelatedInfo> relations) {
        if (product == null) {
            log.warn("device [{}] product [{}] does not exists", (Object)device.getId(), (Object)device.getProductId());
            return Mono.empty();
        }
        DeviceDetail detail = new DeviceDetail().with(product).with(device).with(tags).withRelation(relations);
        return Mono.zip((Mono)this.registry.getProduct(product.getId()), (Mono)this.metadataManager.getProductFeatures(product.getId()).collectList()).flatMap(t2 -> {
            detail.withFeatures((Collection)t2.getT2());
            return detail.with((DeviceProductOperator)t2.getT1());
        }).then(Mono.zip((Mono)this.registry.getDevice(device.getId()).flatMap(operator -> operator.refreshAllConfig().thenReturn(operator)).flatMap(operator -> operator.checkState().map(DeviceState::of).onErrorReturn((Object)device.getState()).filter(state -> state != detail.getState()).doOnNext(detail::setState).flatMap(state -> ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(DeviceInstanceEntity::getState, (Object)state)).where(DeviceInstanceEntity::getId, (Object)device.getId())).execute()).thenReturn(operator)), (Mono)this.metadataManager.getDeviceConfigMetadata(device.getId()).flatMapIterable(ConfigMetadata::getProperties).collectList())).flatMap(tp2 -> detail.with((DeviceOperator)tp2.getT1(), (List)tp2.getT2())).switchIfEmpty(Mono.defer(() -> {
            if (detail.getState() != DeviceState.notActive) {
                return ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(DeviceInstanceEntity::getState, (Object)DeviceState.notActive)).where(DeviceInstanceEntity::getId, (Object)detail.getId())).execute().thenReturn((Object)detail.notActive());
            }
            return Mono.just((Object)detail.notActive());
        }).thenReturn((Object)detail)).onErrorResume(err -> {
            log.warn("get device detail error", err);
            return Mono.just((Object)detail);
        });
    }

    public Mono<DeviceDetail> getDeviceDetail(String deviceId) {
        return this.findById(deviceId).map(Collections::singletonList).flatMapMany(list -> this.convertDeviceInstanceToDetail((List<DeviceInstanceEntity>)list, true, true, true, true)).next();
    }

    public Mono<DeviceState> getDeviceState(String deviceId) {
        return this.registry.getDevice(deviceId).flatMap(DeviceOperator::checkState).flatMap(state -> {
            DeviceState deviceState = DeviceState.of(state);
            return ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(DeviceInstanceEntity::getState, (Object)deviceState)).where(DeviceInstanceEntity::getId, (Object)deviceId)).execute().thenReturn((Object)deviceState);
        }).defaultIfEmpty((Object)DeviceState.notActive);
    }

    public Mono<Map<String, Object>> readProperty(String deviceId, String property) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"error.device_not_found_or_not_activated")).map(DeviceOperator::messageSender).map(sender -> sender.readProperty(new String[]{property}).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate())).flatMapMany(ReadPropertyMessageSender::send).flatMap(LocalDeviceInstanceService.mapReply(ReadPropertyMessageReply::getProperties)).reduceWith(LinkedHashMap::new, (main, map) -> {
            main.putAll(map);
            return main;
        });
    }

    public Mono<DeviceProperty> readAndConvertProperty(String deviceId, String property) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"error.device_not_found_or_not_activated")).flatMap(deviceOperator -> deviceOperator.messageSender().readProperty(new String[]{property}).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).send().flatMap(LocalDeviceInstanceService.mapReply(ReadPropertyMessageReply::getProperties)).reduceWith(LinkedHashMap::new, (main, map) -> {
            main.putAll(map);
            return main;
        }).flatMap(map -> {
            Object value = map.get(property);
            return deviceOperator.getMetadata().map(deviceMetadata -> DeviceProperty.of(value, deviceMetadata.getPropertyOrNull(property)));
        }));
    }

    public Mono<Map<String, Object>> writeProperties(String deviceId, Map<String, Object> properties) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"error.device_not_found_or_not_activated")).flatMap(operator -> operator.messageSender().writeProperty().messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).write(properties).validate()).flatMapMany(WritePropertyMessageSender::send).flatMap(LocalDeviceInstanceService.mapReply(WritePropertyMessageReply::getProperties)).reduceWith(LinkedHashMap::new, (main, map) -> {
            main.putAll(map);
            return main;
        });
    }

    public Flux<?> invokeFunction(String deviceId, String functionId, Map<String, Object> properties) {
        return this.invokeFunction(deviceId, functionId, properties, true);
    }

    public Flux<?> invokeFunction(String deviceId, String functionId, Map<String, Object> properties, boolean convertReply) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"error.device_not_found_or_not_activated")).flatMap(operator -> operator.messageSender().invokeFunction(functionId).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).setParameter(properties).validate()).flatMapMany(FunctionInvokeMessageSender::send).flatMap(convertReply ? LocalDeviceInstanceService.mapReply(FunctionInvokeMessageReply::getOutput) : Mono::just);
    }

    public Mono<Map<String, Object>> readProperties(String deviceId, List<String> properties) {
        return this.registry.getDevice(deviceId).switchIfEmpty(ErrorUtils.notFound((String)"error.device_not_found_or_not_activated")).map(DeviceOperator::messageSender).flatMapMany(sender -> sender.readProperty(new String[0]).read((Collection)properties).messageId((String)IDGenerator.SNOW_FLAKE_STRING.generate()).send()).flatMap(LocalDeviceInstanceService.mapReply(ReadPropertyMessageReply::getProperties)).reduceWith(LinkedHashMap::new, (main, map) -> {
            main.putAll(map);
            return main;
        });
    }

    private static <R extends DeviceMessageReply, T> Function<R, Mono<T>> mapReply(Function<R, T> function) {
        return reply -> {
            if (ErrorCode.REQUEST_HANDLING.name().equals(reply.getCode())) {
                throw new DeviceOperationException(ErrorCode.REQUEST_HANDLING, reply.getMessage());
            }
            if (!reply.isSuccess()) {
                if (StringUtils.isEmpty((Object)reply.getMessage())) {
                    throw new BusinessException("error.reply_is_error");
                }
                throw new BusinessException(reply.getMessage(), reply.getCode());
            }
            return Mono.justOrEmpty(function.apply(reply));
        };
    }

    public Flux<List<DeviceStateInfo>> syncStateBatch(Flux<List<String>> batch, boolean force) {
        return (Flux)batch.concatMap(list -> Flux.fromIterable((Iterable)list).publishOn(Schedulers.parallel()).flatMap(id -> this.registry.getDevice(id).flatMap(operator -> {
            Mono state = force ? operator.checkState().onErrorResume(err -> operator.getState()) : operator.getState();
            return Mono.zip((Mono)state.defaultIfEmpty((Object)-1), (Mono)Mono.just((Object)operator.getDeviceId()), (Mono)operator.getConfig(DeviceConfigKey.isGatewayDevice).defaultIfEmpty((Object)false));
        }).defaultIfEmpty((Object)Tuples.of((Object)-3, (Object)id, (Object)false))).collect(Collectors.groupingBy(Tuple2::getT1)).flatMapIterable(Map::entrySet).flatMap(group -> {
            List deviceIdList = ((List)group.getValue()).stream().map(Tuple2::getT2).collect(Collectors.toList());
            DeviceState state = DeviceState.of((Byte)group.getKey());
            return ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.getRepository().createUpdate().set(DeviceInstanceEntity::getState, (Object)state)).where()).in(DeviceInstanceEntity::getId, deviceIdList)).when(state != DeviceState.notActive, where -> {
                ReactiveUpdate cfr_ignored_0 = (ReactiveUpdate)where.not(DeviceInstanceEntity::getState, (Object)DeviceState.notActive);
            })).execute().thenReturn((Object)((List)group.getValue()).size()).then(Mono.just(deviceIdList.stream().map(id -> DeviceStateInfo.of(id, state)).collect(Collectors.toList())));
        })).as(EntityEventHelper::setDoNotFireEvent);
    }

    public Mono<Void> mergeMetadata(String deviceId, DeviceMetadata metadata, MergeOption ... options) {
        return Mono.zip((Mono)this.findById(deviceId).flatMap(device -> {
            if (StringUtils.hasText((String)device.getDeriveMetadata())) {
                return Mono.just((Object)device.getDeriveMetadata());
            }
            return this.deviceProductService.findById(device.getProductId()).map(DeviceProductEntity::getMetadata);
        }).flatMap(arg_0 -> ((JetLinksDeviceMetadataCodec)JetLinksDeviceMetadataCodec.getInstance()).decode(arg_0)), (Mono)Mono.just((Object)metadata), (older, newer) -> older.merge((ThingMetadata)newer, options)).flatMap(arg_0 -> ((JetLinksDeviceMetadataCodec)JetLinksDeviceMetadataCodec.getInstance()).encode(arg_0)).flatMap(newMetadata -> ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(DeviceInstanceEntity::getDeriveMetadata, newMetadata)).where(DeviceInstanceEntity::getId, (Object)deviceId)).execute().then(this.registry.getDevice(deviceId).flatMap(device -> device.updateMetadata(newMetadata)))).then();
    }

    public Flux<DeviceTagEntity> queryDeviceTag(String deviceId, String ... tags) {
        return ((ReactiveQuery)((ReactiveQuery)this.tagRepository.createQuery().where(DeviceTagEntity::getDeviceId, (Object)deviceId)).when(tags.length > 0, q -> {
            ReactiveQuery cfr_ignored_0 = (ReactiveQuery)q.in(DeviceTagEntity::getKey, Arrays.asList(tags));
        })).fetch();
    }

    @EventListener
    public void handleDeviceDelete(EntityDeletedEvent<DeviceInstanceEntity> event) {
        event.async((Publisher)Flux.concat((Publisher[])new Publisher[]{Flux.fromIterable((Iterable)event.getEntity()).flatMap(device -> this.registry.unregisterDevice(device.getId()).onErrorResume(err -> Mono.empty())).then(), ((ReactiveDelete)((ReactiveDelete)this.tagRepository.createDelete().where()).in(DeviceTagEntity::getDeviceId, (Collection)event.getEntity().stream().map(DeviceInstanceEntity::getId).collect(Collectors.toSet()))).execute()}));
    }

    public Mono<Integer> insert(DeviceInstanceEntity data) {
        return this.handleCreateBefore(data).flatMap(x$0 -> super.insert(x$0));
    }

    public Mono<Integer> insert(Publisher<DeviceInstanceEntity> entityPublisher) {
        return super.insert((Publisher)Flux.from(entityPublisher).flatMap(this::handleCreateBefore));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<DeviceInstanceEntity>> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).flatMapIterable(Function.identity()).as(this::insert);
    }

    private Mono<DeviceInstanceEntity> handleCreateBefore(DeviceInstanceEntity instanceEntity) {
        return Mono.zip((Mono)this.deviceProductService.findById(instanceEntity.getProductId()), (Mono)this.registry.getProduct(instanceEntity.getProductId()).flatMap(DeviceProductOperator::getProtocol), (product, protocol) -> protocol.doBeforeDeviceCreate(Transport.of((String)product.getTransportProtocol()), instanceEntity.toDeviceInfo())).flatMap(Function.identity()).doOnNext(info -> {
            if (StringUtils.isEmpty((Object)instanceEntity.getId())) {
                instanceEntity.setId(info.getId());
            }
            instanceEntity.mergeConfiguration(info.getConfiguration());
        }).thenReturn((Object)instanceEntity);
    }

    public Mono<Void> checkCyclicDependency(DeviceInstanceEntity device) {
        return this.checker.check((Object)device);
    }

    public Mono<Void> checkCyclicDependency(String id, String parentId) {
        DeviceInstanceEntity instance = new DeviceInstanceEntity();
        instance.setId(id);
        instance.setParentId(parentId);
        return this.checker.check((Object)instance);
    }

    public Mono<Void> mergeConfiguration(String deviceId, Map<String, Object> configuration, Function<ReactiveUpdate<DeviceInstanceEntity>, ReactiveUpdate<DeviceInstanceEntity>> updateOperation) {
        if (MapUtils.isEmpty(configuration)) {
            return Mono.empty();
        }
        return this.findById(deviceId).flatMap(device -> {
            device.mergeConfiguration(configuration);
            return ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(device::getConfiguration)).set(device::getFeatures)).set(device::getDeriveMetadata)).as(updateOperation)).where(device::getId)).execute();
        }).then(this.registry.getDevice(deviceId).flatMap(device -> device.setConfigs(configuration))).then();
    }
}

