/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.GenericReactiveTreeSupportCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.device.entity.DeviceCategoryEntity;
import org.reactivestreams.Publisher;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class DeviceCategoryService
extends GenericReactiveTreeSupportCrudService<DeviceCategoryEntity, String>
implements CommandLineRunner {
    private static final String category_splitter = "-";

    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public void setChildren(DeviceCategoryEntity entity, List<DeviceCategoryEntity> children) {
        entity.setChildren(children);
    }

    public void run(String ... args) {
        this.createQuery().fetchOne().switchIfEmpty(this.initDefaultData().then(Mono.empty())).subscribe();
    }

    static void rebuild(String parentId, List<DeviceCategoryEntity> children) {
        if (children == null) {
            return;
        }
        for (DeviceCategoryEntity child : children) {
            String id = child.getId();
            child.setId(parentId + category_splitter + id + category_splitter);
            child.setParentId(parentId + category_splitter);
            DeviceCategoryService.rebuild(parentId + category_splitter + id, child.getChildren());
        }
    }

    private Mono<Void> initDefaultData() {
        return Mono.fromCallable(() -> {
            ClassPathResource resource = new ClassPathResource("device-category.json");
            try (InputStream stream = resource.getInputStream();){
                String json = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                List all = JSON.parseArray((String)json, DeviceCategoryEntity.class);
                List root = TreeSupportEntity.list2tree((Collection)all, DeviceCategoryEntity::setChildren);
                for (DeviceCategoryEntity category : root) {
                    String id = category.getId();
                    category.setId(category_splitter + id + category_splitter);
                    category.setParentId(category_splitter + (String)category.getParentId() + category_splitter);
                    DeviceCategoryService.rebuild(category_splitter + id, category.getChildren());
                }
                List list = root;
                return list;
            }
        }).flatMap(all -> this.save((Publisher)Flux.fromIterable((Iterable)all))).then();
    }
}

