/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.Interval;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.device.measurements.MetadataMeasurementDefinition;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.gateway.DeviceMessageUtils;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.reactivestreams.Publisher;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DevicePropertyMeasurement
extends StaticMeasurement {
    private final PropertyMetadata metadata;
    private final EventBus eventBus;
    private final DeviceDataService deviceDataService;
    private final String productId;
    static ConfigMetadata configMetadata = new DefaultConfigMetadata().add("deviceId", "\u8bbe\u5907", "\u6307\u5b9a\u8bbe\u5907", (DataType)new StringType().expand("selector", (Object)"device-selector")).add("history", "\u5386\u53f2\u6570\u636e\u91cf", "\u67e5\u8be2\u51fa\u5386\u53f2\u6570\u636e\u540e\u5f00\u59cb\u63a8\u9001\u5b9e\u65f6\u6570\u636e", (DataType)new IntType().min((Number)0).expand("defaultValue", (Object)10)).add("from", "\u65f6\u95f4\u4ece", "", (DataType)StringType.GLOBAL).add("to", "\u65f6\u95f4\u81f3", "", (DataType)StringType.GLOBAL);
    static ConfigMetadata aggConfigMetadata = new DefaultConfigMetadata().add("deviceId", "\u8bbe\u5907ID", "", (DataType)StringType.GLOBAL).add("time", "\u5468\u671f", "\u4f8b\u5982: 1h,10m,30s", (DataType)StringType.GLOBAL).add("agg", "\u805a\u5408\u7c7b\u578b", "count,sum,avg,max,min", (DataType)StringType.GLOBAL).add("format", "\u65f6\u95f4\u683c\u5f0f", "\u5982: MM-dd:HH", (DataType)StringType.GLOBAL).add("limit", "\u6700\u5927\u6570\u636e\u91cf", "", (DataType)StringType.GLOBAL).add("from", "\u65f6\u95f4\u4ece", "", (DataType)StringType.GLOBAL).add("to", "\u65f6\u95f4\u81f3", "", (DataType)StringType.GLOBAL);

    public DevicePropertyMeasurement(String productId, EventBus eventBus, PropertyMetadata metadata, DeviceDataService deviceDataService) {
        super((MeasurementDefinition)MetadataMeasurementDefinition.of((Metadata)metadata));
        this.productId = productId;
        this.eventBus = eventBus;
        this.metadata = metadata;
        this.deviceDataService = deviceDataService;
        this.addDimension(new RealTimeDevicePropertyDimension());
        this.addDimension(new HistoryDevicePropertyDimension());
        if (metadata.getValueType() instanceof NumberType) {
            this.addDimension(new AggDevicePropertyDimension());
        }
    }

    Map<String, Object> createValue(Object value) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        DataType type = this.metadata.getValueType();
        value = type instanceof Converter ? ((Converter)type).convert(value) : value;
        values.put("value", value);
        values.put("formatValue", type.format(value));
        return values;
    }

    Flux<SimpleMeasurementValue> fromHistory(String deviceId, int history) {
        return history <= 0 ? Flux.empty() : ((Flux)QueryParamEntity.newQuery().doPaging(0, history).execute(q -> this.deviceDataService.queryProperty(deviceId, (QueryParamEntity)q, this.metadata.getId()))).map(data -> SimpleMeasurementValue.of((Object)data, (long)data.getTimestamp())).sort(MeasurementValue.sort());
    }

    Flux<MeasurementValue> fromRealTime(String deviceId) {
        Subscription subscription = Subscription.of((String)"realtime-device-property-measurement", (String[])new String[]{"/device/" + this.productId + "/" + deviceId + "/message/property/report", "/device/" + this.productId + "/" + deviceId + "/message/property/*/reply"}, (Subscription.Feature[])new Subscription.Feature[]{Subscription.Feature.local, Subscription.Feature.broker});
        return this.eventBus.subscribe(subscription, DeviceMessage.class).flatMap(msg -> Mono.justOrEmpty((Optional)DeviceMessageUtils.tryGetProperties((DeviceMessage)msg))).filter(msg -> msg.containsKey(this.metadata.getId())).map(msg -> SimpleMeasurementValue.of(this.createValue(msg.get(this.metadata.getId())), (long)System.currentTimeMillis()));
    }

    private class RealTimeDevicePropertyDimension
    implements MeasurementDimension {
        private RealTimeDevicePropertyDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.realTime;
        }

        public DataType getValueType() {
            return new ObjectType().addProperty("property", "\u5c5e\u6027", (DataType)StringType.GLOBAL).addProperty("value", "\u503c", DevicePropertyMeasurement.this.metadata.getValueType()).addProperty("formatValue", "\u683c\u5f0f\u5316\u503c", (DataType)StringType.GLOBAL);
        }

        public ConfigMetadata getParams() {
            return configMetadata;
        }

        public boolean isRealTime() {
            return true;
        }

        public Flux<MeasurementValue> getValue(MeasurementParameter parameter) {
            return Mono.justOrEmpty((Optional)parameter.getString("deviceId")).flatMapMany(deviceId -> {
                int history = parameter.getInt("history").orElse(0);
                return Flux.concat((Publisher[])new Publisher[]{DevicePropertyMeasurement.this.fromHistory((String)deviceId, history), DevicePropertyMeasurement.this.fromRealTime((String)deviceId)});
            });
        }
    }

    private class HistoryDevicePropertyDimension
    implements MeasurementDimension {
        private HistoryDevicePropertyDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.history;
        }

        public DataType getValueType() {
            return new ObjectType().addProperty("property", "\u5c5e\u6027", (DataType)StringType.GLOBAL).addProperty("value", "\u503c", DevicePropertyMeasurement.this.metadata.getValueType()).addProperty("formatValue", "\u683c\u5f0f\u5316\u503c", (DataType)StringType.GLOBAL);
        }

        public ConfigMetadata getParams() {
            return configMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Flux<MeasurementValue> getValue(MeasurementParameter parameter) {
            return Mono.justOrEmpty((Optional)parameter.getString("deviceId")).flatMapMany(deviceId -> {
                int history = parameter.getInt("history").orElse(1);
                return ((Flux)((Query)QueryParamEntity.newQuery().doPaging(0, history).as(query -> (Query)((Query)query.gte("timestamp", parameter.getDate("from").orElse(null))).lte("timestamp", parameter.getDate("to").orElse(null)))).execute(q -> DevicePropertyMeasurement.this.deviceDataService.queryProperty((String)deviceId, (QueryParamEntity)q, DevicePropertyMeasurement.this.metadata.getId()))).map(data -> SimpleMeasurementValue.of((Object)data, (String)DateFormatter.toString((Date)new Date(data.getTimestamp()), (String)parameter.getString("timeFormat", "HH:mm:ss")), (long)data.getTimestamp())).sort(MeasurementValue.sort());
            });
        }
    }

    private class AggDevicePropertyDimension
    implements MeasurementDimension {
        private AggDevicePropertyDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.agg;
        }

        public DataType getValueType() {
            return new ObjectType().addProperty("value", "\u6570\u636e", (DataType)new ObjectType().addProperty("property", (DataType)StringType.GLOBAL).addProperty("value", DevicePropertyMeasurement.this.metadata.getValueType()).addProperty("formatValue", (DataType)StringType.GLOBAL)).addProperty("timeString", "\u65f6\u95f4", (DataType)StringType.GLOBAL);
        }

        public ConfigMetadata getParams() {
            return aggConfigMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Flux<SimpleMeasurementValue> getValue(MeasurementParameter parameter) {
            String deviceId = parameter.getString("deviceId", null);
            DeviceDataService.AggregationRequest request = new DeviceDataService.AggregationRequest();
            DeviceDataService.DevicePropertyAggregation aggregation = new DeviceDataService.DevicePropertyAggregation(DevicePropertyMeasurement.this.metadata.getId(), DevicePropertyMeasurement.this.metadata.getId(), parameter.getString("agg").map(String::toUpperCase).map(Aggregation::valueOf).orElse(Aggregation.AVG));
            String format = parameter.getString("format", "HH:mm:ss");
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
            request.setLimit(parameter.getInt("limit", 10));
            request.setInterval(parameter.getInterval("time", Interval.ofSeconds((int)10)));
            request.setFormat(format);
            request.setFrom(parameter.getDate("from", DateTime.now().plusDays(-1).toDate()));
            request.setTo(parameter.getDate("to", DateTime.now().plusDays(-1).toDate()));
            Flux<AggregationData> dataFlux = StringUtils.hasText((String)deviceId) ? DevicePropertyMeasurement.this.deviceDataService.aggregationPropertiesByDevice(deviceId, request, aggregation) : DevicePropertyMeasurement.this.deviceDataService.aggregationPropertiesByProduct(DevicePropertyMeasurement.this.productId, request, aggregation);
            return dataFlux.map(data -> {
                long ts = data.getString("time").map(time -> DateTime.parse((String)time, (DateTimeFormatter)formatter).getMillis()).orElse(System.currentTimeMillis());
                return SimpleMeasurementValue.of(DevicePropertyMeasurement.this.createValue(data.get(DevicePropertyMeasurement.this.metadata.getId()).orElse(0)), (String)data.getString("time", ""), (long)ts);
            }).sort();
        }
    }
}

