/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.dimension;

import java.util.Collections;
import net.zstong.awump.base.entity.AwInstitutionEntity;
import net.zstong.awump.dimension.InstitutionDimensionType;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import org.hswebframework.web.system.authorization.defaults.service.terms.DimensionTerm;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class InstitutionDimensionProvider
extends GenericEntity<String>
implements DimensionProvider {
    @Autowired
    private ReactiveRepository<AwInstitutionEntity, String> repository;
    @Autowired
    private DefaultDimensionUserService dimensionUserService;

    protected Flux<? extends Dimension> convertToDimension(Publisher<AwInstitutionEntity> source) {
        return Flux.from(source).flatMap(this::convertToDimension);
    }

    protected Mono<Dimension> convertToDimension(AwInstitutionEntity entity) {
        return Mono.just((Object)entity.toDimension(true));
    }

    public Flux<? extends DimensionType> getAllType() {
        return Flux.just((Object)((Object)InstitutionDimensionType.institution));
    }

    public Mono<? extends Dimension> getDimensionById(DimensionType dimensionType, String s) {
        if (!dimensionType.isSameType((DimensionType)InstitutionDimensionType.institution)) {
            return Mono.empty();
        }
        return ((Flux)this.repository.findById((Object)s).as(this::convertToDimension)).singleOrEmpty();
    }

    public Flux<String> getUserIdByDimensionId(String s) {
        return ((ReactiveQuery)((ReactiveQuery)this.dimensionUserService.createQuery().where(DimensionUserEntity::getDimensionId, (Object)s)).and(DimensionUserEntity::getDimensionTypeId, (Object)InstitutionDimensionType.institution.getId())).fetch().map(DimensionUserEntity::getUserId);
    }

    public Flux<? extends Dimension> getDimensionByUserId(String s) {
        return (Flux)((ReactiveQuery)DimensionTerm.inject((Conditional)this.repository.createQuery(), (String)"id", (String)InstitutionDimensionType.institution.getId(), Collections.singletonList(s))).fetch().as(this::convertToDimension);
    }

    public InstitutionDimensionProvider(ReactiveRepository<AwInstitutionEntity, String> repository, DefaultDimensionUserService dimensionUserService) {
        this.repository = repository;
        this.dimensionUserService = dimensionUserService;
    }
}

