/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.base.service;

import java.util.List;
import net.zstong.awump.base.entity.AwInstitutionInfo;
import net.zstong.awump.base.entity.AwRegionEntity;
import net.zstong.awump.base.entity.AwWarehouseEntity;
import net.zstong.awump.base.entity.AwWarehouseInfo;
import net.zstong.awump.base.service.AwInstitutionService;
import net.zstong.awump.base.service.AwRegionService;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AwWarehouseService
extends GenericReactiveCrudService<AwWarehouseEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(AwWarehouseService.class);
    @Autowired
    private AwInstitutionService awInstitutionService;
    @Autowired
    private AwRegionService awRegionService;

    public Mono<PagerResult<AwWarehouseInfo>> queryInfo(Mono<QueryParamEntity> paramBody) {
        return paramBody.flatMap(param -> this.queryPager((QueryParamEntity)param).flatMap(result -> Flux.fromIterable((Iterable)result.getData()).flatMap(entity -> this.toInfo(AwWarehouseInfo.of(entity))).collectList().map(info -> PagerResult.of((int)result.getTotal(), (List)info, (QueryParam)param))));
    }

    private Mono<AwWarehouseInfo> toInfo(AwWarehouseInfo info) {
        return this.awInstitutionService.findById(info.getInstitutionId()).flatMap(i -> {
            info.setInstitution(AwInstitutionInfo.of(i));
            return this.awRegionService.findById(i.getRegionId()).map(r -> {
                info.setRegion((AwRegionEntity)((Object)((Object)r)));
                return info;
            }).switchIfEmpty(Mono.just((Object)((Object)info)));
        }).switchIfEmpty(Mono.just((Object)((Object)info)));
    }
}

