package net.zstong.awump.inspection.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.base.entity.BaseEntity;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
* @author yuanhc
* @date 2023-07-01
*/
@Getter
@Setter
@Table(name="aw_inspection_plan")
@Comment("巡检计划")
@EnableEntityEvent
public class AwInspectionPlanEntity extends BaseEntity<String> {



    /** 所属单位 */
    @Schema(description = "所属单位")
    @Column(name = "institution_id_",length =64 )
    private String institutionId;


    /** 所属库房 */
    @Schema(description = "所属库房")
    @Column(name = "warehouse_id_",length =64 )
    private String warehouseId;


    /** 计划名称 */
    @Schema(description = "计划名称")
    @Column(name = "name_",length =256 )
    private String name;


    /** 计划类型 */
    @Schema(description = "计划类型")
    @Column(name = "plan_type_",nullable = false,length =64 )
    @NotBlank(message = "计划类型不能为空", groups = CreateGroup.class)
    private String planType;


    /** 开始时间 */
    @Schema(description = "开始时间")
    @Column(name = "start_date_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startDate;


    /** 结束时间 */
    @Schema(description = "结束时间")
    @Column(name = "end_date_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endDate;


    /** 责任人 */
    @Schema(description = "责任人")
    @Column(name = "inspector_",length =64 )
    private String inspector;


    /** 状态 */
    @Schema(description = "状态")
    @Column(name = "status_",length =32 )
    private String status;


    /** 巡检规则 */
    @Schema(description = "巡检规则")
    @Column(name = "rule_",length =65535 )
    private String rule;


    /** 报告发送方式 */
    @Schema(description = "报告发送方式")
    @Column(name = "report_send_",length =32 )
    private String reportSend;


    /** 邮箱地址 */
    @Schema(description = "邮箱地址")
    @Column(name = "report_email_",length =256 )
    private String reportEmail;


    /** 报告模板 */
    @Schema(description = "报告模板")
    @Column(name = "report_tpl_",length =256 )
    private String reportTpl;


    /** 描述 */
    @Schema(description = "描述")
    @Column(name = "describe_",length =200 )
    private String describe;











}