/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.things;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetlinks.community.tdengine.things.TDengineThingDataHelper;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.things.data.operations.RowModeSaveOperationsBase;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.ThingsRegistry;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Predicate3;

class TDengineRowModeSaveOperations
extends RowModeSaveOperationsBase {
    private final TDengineThingDataHelper helper;
    static Set<String> IGNORE_COLUMN = new HashSet<String>(Arrays.asList("id", "objectValue", "arrayValue", "geoValue", "timeValue", "timestamp"));

    public TDengineRowModeSaveOperations(ThingsRegistry registry, MetricBuilder metricBuilder, DataSettings settings, TDengineThingDataHelper helper) {
        super(registry, metricBuilder, settings);
        this.helper = helper;
    }

    protected boolean isTagValue(String metric, String key, Object value) {
        return Objects.equals(this.metricBuilder.getThingIdProperty(), key) || Objects.equals("property", key);
    }

    protected String createPropertyDataId(String property, ThingMessage message, long timestamp) {
        return String.valueOf(timestamp);
    }

    protected Map<String, Object> createRowPropertyData(String id, long timestamp, ThingMessage message, PropertyMetadata property, Object value) {
        Map data = super.createRowPropertyData(id, timestamp, message, property, value);
        IGNORE_COLUMN.forEach(data::remove);
        return data;
    }

    protected Mono<Void> doSave(String metric, TimeSeriesData data) {
        return this.helper.doSave(metric, data, (Predicate3<String, String, Object>)((Predicate3)this::isTagValue));
    }

    protected Mono<Void> doSave(String metric, Flux<TimeSeriesData> data) {
        return this.helper.doSave(metric, data, (Predicate3<String, String, Object>)((Predicate3)this::isTagValue));
    }
}

