/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.term;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public enum TDengineTermType {
    is(true, "="),
    eq(true, "="),
    not(true, "!="),
    notnull(false, "!="){

        @Override
        protected void doBuild(String column, Object value, StringJoiner sql) {
            String val = String.valueOf(value);
            sql.add(this.escapeColumn(column)).add(" is not null ");
        }
    }
    ,
    gt(true, ">"),
    gte(true, ">="),
    lt(true, "<"),
    lte(true, "<="),
    like(false, "like"){

        @Override
        protected void doBuild(String column, Object value, StringJoiner sql) {
            String val = String.valueOf(value);
            sql.add(this.escapeColumn(column)).add(" like ").add(val);
        }
    }
    ,
    btw(true, "btw"){

        @Override
        protected void doBuild(String column, Object value, StringJoiner sql) {
            ArrayList<Object> values = new ArrayList<Object>(3.convertList(value));
            if (values.isEmpty()) {
                return;
            }
            gte.build(column, values.get(0), sql);
            if (values.size() >= 2) {
                sql.add(" and ");
                lte.build(column, values.get(1), sql);
            }
        }
    }
    ,
    in(false, "in"){

        @Override
        protected void doBuild(String column, Object value, StringJoiner sql) {
            String colSql = this.escapeColumn(column);
            sql.add(colSql).add(" in ").add(4.convertList(value).stream().map(this::createValue).collect(Collectors.joining(" , ", "(", ")")));
        }
    }
    ,
    nin(false, "nin"){

        @Override
        protected void doBuild(String column, Object value, StringJoiner sql) {
            String colSql = this.escapeColumn(column);
            sql.add(colSql).add(" not in ").add(5.convertList(value).stream().map(this::createValue).collect(Collectors.joining(" , ", "(", ")")));
        }
    };

    final boolean forNumber;
    final String expr;

    public static Collection<Object> convertList(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            value = ((String)value).split("[,]");
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    protected String escapeValue(String value) {
        return value.replace("'", "\\'");
    }

    protected String escapeColumn(String value) {
        return value;
    }

    protected String createValue(Object value) {
        String strVal = this.escapeValue(value.toString());
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (strVal.startsWith("'") && strVal.endsWith("'")) {
            return strVal;
        }
        return "'" + strVal + "'";
    }

    protected void doBuild(String column, Object value, StringJoiner sql) {
        sql.add(this.escapeColumn(column)).add(" ").add(this.expr).add(" ").add(this.createValue(value));
    }

    public String build(String column, Object value) {
        StringJoiner joiner = new StringJoiner("");
        this.build(column, value, joiner);
        return joiner.toString();
    }

    public void build(String column, Object value, StringJoiner sql) {
        if (StringUtils.isEmpty((Object)column) || value == null) {
            return;
        }
        this.doBuild(column, value, sql);
    }

    private TDengineTermType(boolean forNumber, String expr) {
        this.forNumber = forNumber;
        this.expr = expr;
    }
}

