/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.jetlinks.community.relation.entity.RelatedEntity;
import org.jetlinks.community.relation.entity.RelationEntity;
import org.jetlinks.community.relation.service.RelatedObjectInfo;
import org.jetlinks.community.relation.service.request.SaveRelationRequest;
import org.jetlinks.community.relation.service.response.RelatedInfo;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Service
public class RelationService
extends GenericReactiveCrudService<RelationEntity, String> {
    private final ReactiveRepository<RelatedEntity, String> relatedRepository;

    public Flux<RelatedInfo> getRelationInfo(String type, Collection<String> idList) {
        return Mono.zip((Mono)((ReactiveQuery)((ReactiveQuery)this.createQuery().where(RelationEntity::getObjectType, (Object)type)).orderBy(new SortOrder[]{SortOrder.asc(RelationEntity::getCreateTime)})).fetch().collectList().filter(CollectionUtils::isNotEmpty), (Mono)((ReactiveQuery)this.relatedRepository.createQuery().in(RelatedEntity::getObjectKey, RelatedEntity.generateKey(type, idList))).fetch().groupBy(RelatedEntity::getObjectId).flatMap(group -> group.groupBy(rel -> Tuples.of((Object)rel.getRelatedType(), (Object)rel.getRelation())).flatMap(relateGroup -> relateGroup.map(RelatedObjectInfo::ofRelated).collectList().map(list -> Tuples.of((Object)relateGroup.key(), (Object)list))).collectMap(Tuple2::getT1, Tuple2::getT2).map(mapping -> Tuples.of((Object)group.key(), (Object)mapping))).collectMap(Tuple2::getT1, Tuple2::getT2), (relations, relatedMapping) -> Flux.fromIterable((Iterable)idList).flatMap(objectId -> Flux.fromIterable((Iterable)relations).map(relation -> {
            RelatedInfo relatedInfo = new RelatedInfo();
            relatedInfo.setObjectId((String)objectId);
            relatedInfo.setRelation(relation.getRelation());
            relatedInfo.setRelationName(relation.getName());
            relatedInfo.setRelatedType(relatedInfo.getRelatedType());
            relatedInfo.setRelationExpands(relatedInfo.getRelationExpands());
            List related = (List)relatedMapping.getOrDefault(objectId, Collections.emptyMap()).get(Tuples.of((Object)relation.getTargetType(), (Object)relation.getRelation()));
            relatedInfo.setRelated(related);
            return relatedInfo;
        }))).flatMapMany(Function.identity());
    }

    public Flux<RelatedInfo> getRelationInfo(String type, String id) {
        return this.getRelationInfo(type, Collections.singletonList(id));
    }

    public Mono<Void> saveRelated(String type, String id, Flux<SaveRelationRequest> requestFlux) {
        return ((Mono)requestFlux.groupBy(request -> Tuples.of((Object)request.getRelatedType(), (Object)request.getRelation())).flatMap(group -> ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)this.relatedRepository.createDelete().where(RelatedEntity::getObjectKey, (Object)RelatedEntity.generateKey(type, id))).and(RelatedEntity::getRelatedType, ((Tuple2)group.key()).getT1())).and(RelatedEntity::getRelation, ((Tuple2)group.key()).getT2())).execute().thenMany((Publisher)group)).filter(request -> CollectionUtils.isNotEmpty(request.getRelated())).flatMap(request -> Flux.fromIterable(request.getRelated()).map(related -> new RelatedEntity().withObject(type, id).withRelated(request.getRelatedType(), (RelatedObjectInfo)related, request.getRelation()))).as(arg_0 -> this.relatedRepository.insert(arg_0))).then();
    }

    public RelationService(ReactiveRepository<RelatedEntity, String> relatedRepository) {
        this.relatedRepository = relatedRepository;
    }
}

