/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl.property;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetlinks.community.relation.impl.property.PropertyOperationStrategy;
import org.jetlinks.core.config.ConfigKey;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SimplePropertyOperation<O>
implements PropertyOperationStrategy {
    private final Map<String, Function<O, ?>> mappers = new HashMap();
    private final Mono<O> supplier;

    public SimplePropertyOperation(Mono<O> supplier) {
        this.supplier = supplier;
    }

    @Override
    public boolean isSupported(String key) {
        return this.mappers.containsKey(key);
    }

    public SimplePropertyOperation<O> addMapper(String key, Function<O, ?> mapper) {
        this.mappers.put(key, mapper);
        return this;
    }

    public <T> SimplePropertyOperation<O> addMapper(ConfigKey<T> key, Function<O, T> mapper) {
        return this.addMapper(key.getKey(), mapper);
    }

    public <T> SimplePropertyOperation<O> addAsyncMapper(ConfigKey<T> key, BiFunction<O, ConfigKey<T>, Mono<T>> mapper) {
        return this.addMapper(key.getKey(), (O obj) -> (Mono)mapper.apply(obj, key));
    }

    public Mono<Object> get(String key) {
        Function mapper = this.mappers.get(key);
        if (mapper == null) {
            return Mono.empty();
        }
        return this.supplier.flatMap(obj -> {
            Object val = mapper.apply(obj);
            if (val instanceof Publisher) {
                return Mono.from((Publisher)((Publisher)val));
            }
            return Mono.justOrEmpty(val);
        });
    }
}

