/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl.property;

import java.util.List;
import org.jetlinks.community.relation.impl.property.PropertyOperationStrategy;
import reactor.core.publisher.Mono;

class CompositePropertyOperation
implements PropertyOperationStrategy {
    private final List<PropertyOperationStrategy> strategies;

    @Override
    public boolean isSupported(String key) {
        return this.getStrategy(key) != null;
    }

    private PropertyOperationStrategy getStrategy(String key) {
        for (PropertyOperationStrategy strategy : this.strategies) {
            if (!strategy.isSupported(key)) continue;
            return strategy;
        }
        return null;
    }

    public Mono<Object> get(String key) {
        PropertyOperationStrategy strategy = this.getStrategy(key);
        if (strategy == null) {
            return Mono.empty();
        }
        return strategy.get(key);
    }

    public CompositePropertyOperation(List<PropertyOperationStrategy> strategies) {
        this.strategies = strategies;
    }
}

