/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.index.strategies;

import java.time.LocalDate;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexProperties;
import org.jetlinks.community.elastic.search.index.strategies.TemplateElasticSearchIndexStrategy;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticsearchClient;
import org.springframework.stereotype.Component;

@Component
public class TimeByDayElasticSearchIndexStrategy
extends TemplateElasticSearchIndexStrategy {
    public TimeByDayElasticSearchIndexStrategy(ReactiveElasticsearchClient client, ElasticSearchIndexProperties properties) {
        super("time-by-day", client, properties);
    }

    @Override
    public String getIndexForSave(String index) {
        LocalDate now = LocalDate.now();
        String idx = this.wrapIndex(index);
        return idx + "_" + now.getYear() + "-" + (now.getMonthValue() < 10 ? "0" : "") + now.getMonthValue() + "-" + (now.getDayOfMonth() < 10 ? "0" : "") + now.getDayOfMonth();
    }
}

