/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.index;

import org.elasticsearch.common.settings.Settings;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="elasticsearch.index.settings")
public class ElasticSearchIndexProperties {
    private int numberOfShards = 1;
    private int numberOfReplicas = 0;

    public Settings toSettings() {
        return Settings.builder().put("number_of_shards", Math.max(1, this.numberOfShards)).put("number_of_replicas", this.numberOfReplicas).build();
    }

    public static ElasticSearchIndexPropertiesBuilder builder() {
        return new ElasticSearchIndexPropertiesBuilder();
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public void setNumberOfShards(int numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public void setNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public ElasticSearchIndexProperties() {
    }

    public ElasticSearchIndexProperties(int numberOfShards, int numberOfReplicas) {
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
    }

    public static class ElasticSearchIndexPropertiesBuilder {
        private int numberOfShards;
        private int numberOfReplicas;

        ElasticSearchIndexPropertiesBuilder() {
        }

        public ElasticSearchIndexPropertiesBuilder numberOfShards(int numberOfShards) {
            this.numberOfShards = numberOfShards;
            return this;
        }

        public ElasticSearchIndexPropertiesBuilder numberOfReplicas(int numberOfReplicas) {
            this.numberOfReplicas = numberOfReplicas;
            return this;
        }

        public ElasticSearchIndexProperties build() {
            return new ElasticSearchIndexProperties(this.numberOfShards, this.numberOfReplicas);
        }

        public String toString() {
            return "ElasticSearchIndexProperties.ElasticSearchIndexPropertiesBuilder(numberOfShards=" + this.numberOfShards + ", numberOfReplicas=" + this.numberOfReplicas + ")";
        }
    }
}

