/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.web.dict.EnumDict;

public enum ElasticDateFormat implements EnumDict<String>
{
    epoch_millis("epoch_millis", "\u6beb\u79d2"),
    epoch_second("epoch_second", "\u79d2"),
    strict_date("strict_date", "yyyy-MM-dd"),
    basic_date_time("basic_date_time", "yyyyMMdd'T'HHmmss.SSSZ"),
    strict_date_time("strict_date_time", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ"),
    strict_date_hour_minute_second("strict_date_hour_minute_second", "yyyy-MM-dd'T'HH:mm:ss"),
    strict_hour_minute_second("strict_hour_minute_second", "HH:mm:ss"),
    simple_date("yyyy-MM-dd HH:mm:ss", "\u901a\u7528\u683c\u5f0f");

    private String value;
    private final String text;

    public static String getFormat(ElasticDateFormat ... dateFormats) {
        return ElasticDateFormat.getFormat(Arrays.asList(dateFormats));
    }

    public static String getFormat(List<ElasticDateFormat> dateFormats) {
        return ElasticDateFormat.getFormatStr(dateFormats.stream().map(ElasticDateFormat::getValue).collect(Collectors.toList()));
    }

    public static String getFormatStr(List<String> dateFormats) {
        StringBuffer format = new StringBuffer();
        for (int i = 0; i < dateFormats.size(); ++i) {
            format.append(dateFormats.get(i));
            if (i == dateFormats.size() - 1) continue;
            format.append("||");
        }
        return format.toString();
    }

    public String getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    private ElasticDateFormat(String value, String text) {
        this.value = value;
        this.text = text;
    }
}

