/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.configuration;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="elasticsearch.client")
public class ElasticSearchProperties {
    private String host = "localhost";
    private int port = 9200;
    private int connectionRequestTimeout = 5000;
    private int connectTimeout = 2000;
    private int socketTimeout = 2000;
    private int maxConnTotal = 30;
    private List<String> hosts;

    public HttpHost[] createHosts() {
        if (CollectionUtils.isEmpty(this.hosts)) {
            return new HttpHost[]{new HttpHost(this.host, this.port, "http")};
        }
        return (HttpHost[])this.hosts.stream().map(HttpHost::create).toArray(HttpHost[]::new);
    }

    public RequestConfig.Builder applyRequestConfigBuilder(RequestConfig.Builder builder) {
        builder.setConnectTimeout(this.connectTimeout);
        builder.setConnectionRequestTimeout(this.connectionRequestTimeout);
        builder.setSocketTimeout(this.socketTimeout);
        return builder;
    }

    public HttpAsyncClientBuilder applyHttpAsyncClientBuilder(HttpAsyncClientBuilder builder) {
        builder.setMaxConnTotal(this.maxConnTotal);
        return builder;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getMaxConnTotal() {
        return this.maxConnTotal;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setMaxConnTotal(int maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }
}

