/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.aggreation.bucket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.community.elastic.search.aggreation.metrics.MetricsResponseSingleValue;

public class Bucket {
    private String key;
    private String name;
    private long count;
    private String fromAsString;
    private Object from;
    private String toAsString;
    private Object to;
    private MetricsResponseSingleValue sum;
    private MetricsResponseSingleValue valueCount;
    private MetricsResponseSingleValue avg;
    private MetricsResponseSingleValue min;
    private MetricsResponseSingleValue max;
    private List<Bucket> buckets;

    private double toNumber(double number) {
        return Double.isInfinite(number) || Double.isNaN(number) ? 0.0 : number;
    }

    public Map<String, Number> toMap() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        if (this.sum != null) {
            map.put(this.sum.getName(), this.toNumber(this.sum.getValue()));
        }
        if (this.valueCount != null) {
            map.put(this.valueCount.getName(), this.toNumber(this.valueCount.getValue()));
        }
        if (this.avg != null) {
            map.put(this.avg.getName(), this.toNumber(this.avg.getValue()));
        }
        if (this.min != null) {
            map.put(this.min.getName(), this.toNumber(this.min.getValue()));
        }
        if (this.max != null) {
            map.put(this.max.getName(), this.toNumber(this.max.getValue()));
        }
        return map;
    }

    public static BucketBuilder builder() {
        return new BucketBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public long getCount() {
        return this.count;
    }

    public String getFromAsString() {
        return this.fromAsString;
    }

    public Object getFrom() {
        return this.from;
    }

    public String getToAsString() {
        return this.toAsString;
    }

    public Object getTo() {
        return this.to;
    }

    public MetricsResponseSingleValue getSum() {
        return this.sum;
    }

    public MetricsResponseSingleValue getValueCount() {
        return this.valueCount;
    }

    public MetricsResponseSingleValue getAvg() {
        return this.avg;
    }

    public MetricsResponseSingleValue getMin() {
        return this.min;
    }

    public MetricsResponseSingleValue getMax() {
        return this.max;
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setFromAsString(String fromAsString) {
        this.fromAsString = fromAsString;
    }

    public void setFrom(Object from) {
        this.from = from;
    }

    public void setToAsString(String toAsString) {
        this.toAsString = toAsString;
    }

    public void setTo(Object to) {
        this.to = to;
    }

    public void setSum(MetricsResponseSingleValue sum) {
        this.sum = sum;
    }

    public void setValueCount(MetricsResponseSingleValue valueCount) {
        this.valueCount = valueCount;
    }

    public void setAvg(MetricsResponseSingleValue avg) {
        this.avg = avg;
    }

    public void setMin(MetricsResponseSingleValue min) {
        this.min = min;
    }

    public void setMax(MetricsResponseSingleValue max) {
        this.max = max;
    }

    public void setBuckets(List<Bucket> buckets) {
        this.buckets = buckets;
    }

    public Bucket(String key, String name, long count, String fromAsString, Object from, String toAsString, Object to, MetricsResponseSingleValue sum, MetricsResponseSingleValue valueCount, MetricsResponseSingleValue avg, MetricsResponseSingleValue min, MetricsResponseSingleValue max, List<Bucket> buckets) {
        this.key = key;
        this.name = name;
        this.count = count;
        this.fromAsString = fromAsString;
        this.from = from;
        this.toAsString = toAsString;
        this.to = to;
        this.sum = sum;
        this.valueCount = valueCount;
        this.avg = avg;
        this.min = min;
        this.max = max;
        this.buckets = buckets;
    }

    public Bucket() {
    }

    public static class BucketBuilder {
        private String key;
        private String name;
        private long count;
        private String fromAsString;
        private Object from;
        private String toAsString;
        private Object to;
        private MetricsResponseSingleValue sum;
        private MetricsResponseSingleValue valueCount;
        private MetricsResponseSingleValue avg;
        private MetricsResponseSingleValue min;
        private MetricsResponseSingleValue max;
        private List<Bucket> buckets;

        BucketBuilder() {
        }

        public BucketBuilder key(String key) {
            this.key = key;
            return this;
        }

        public BucketBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BucketBuilder count(long count) {
            this.count = count;
            return this;
        }

        public BucketBuilder fromAsString(String fromAsString) {
            this.fromAsString = fromAsString;
            return this;
        }

        public BucketBuilder from(Object from) {
            this.from = from;
            return this;
        }

        public BucketBuilder toAsString(String toAsString) {
            this.toAsString = toAsString;
            return this;
        }

        public BucketBuilder to(Object to) {
            this.to = to;
            return this;
        }

        public BucketBuilder sum(MetricsResponseSingleValue sum) {
            this.sum = sum;
            return this;
        }

        public BucketBuilder valueCount(MetricsResponseSingleValue valueCount) {
            this.valueCount = valueCount;
            return this;
        }

        public BucketBuilder avg(MetricsResponseSingleValue avg) {
            this.avg = avg;
            return this;
        }

        public BucketBuilder min(MetricsResponseSingleValue min) {
            this.min = min;
            return this;
        }

        public BucketBuilder max(MetricsResponseSingleValue max) {
            this.max = max;
            return this;
        }

        public BucketBuilder buckets(List<Bucket> buckets) {
            this.buckets = buckets;
            return this;
        }

        public Bucket build() {
            return new Bucket(this.key, this.name, this.count, this.fromAsString, this.from, this.toAsString, this.to, this.sum, this.valueCount, this.avg, this.min, this.max, this.buckets);
        }

        public String toString() {
            return "Bucket.BucketBuilder(key=" + this.key + ", name=" + this.name + ", count=" + this.count + ", fromAsString=" + this.fromAsString + ", from=" + this.from + ", toAsString=" + this.toAsString + ", to=" + this.to + ", sum=" + this.sum + ", valueCount=" + this.valueCount + ", avg=" + this.avg + ", min=" + this.min + ", max=" + this.max + ", buckets=" + this.buckets + ")";
        }
    }
}

