/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.device;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import javax.persistence.Column;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.jetlinks.community.configure.device.UnknownDeviceSessionProvider;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.server.session.DeviceSessionProvider;
import org.jetlinks.core.server.session.PersistentSession;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Generated
public class PersistentSessionEntity
extends GenericEntity<String> {
    @Schema(description="\u8bbe\u5907\u4f1a\u8bdd\u63d0\u4f9b\u5546")
    @Column(length=32, nullable=false)
    private String provider;
    @Schema(description="\u8bbe\u5907\u8fde\u63a5\u7684\u7f51\u5173\u670d\u52a1ID")
    @Column(length=64, nullable=false)
    private String serverId;
    @Schema(description="\u8bbe\u5907ID")
    @Column(length=64, nullable=false)
    private String deviceId;
    @Schema(description="\u4f1a\u8bdd\u8d85\u65f6\u65f6\u95f4")
    @Column
    private Long keepAliveTimeout;
    @Schema(description="\u6700\u8fd1\u4f1a\u8bdd\u65f6\u95f4")
    @Column
    private Long lastKeepAliveTime;
    @Schema(description="\u4f1a\u8bdd\u5e8f\u5217\u5316")
    @Column
    @ColumnType(javaType=String.class, jdbcType=JDBCType.LONGVARCHAR)
    private String sessionBase64;

    public static Mono<PersistentSessionEntity> from(String serverId, PersistentSession session, DeviceRegistry registry) {
        PersistentSessionEntity entity = new PersistentSessionEntity();
        entity.setId(session.getId());
        entity.setProvider(session.getProvider());
        entity.setServerId(serverId);
        entity.setDeviceId(session.getDeviceId());
        entity.setKeepAliveTimeout(session.getKeepAliveTimeout().toMillis());
        entity.setLastKeepAliveTime(session.lastPingTime());
        DeviceSessionProvider provider = DeviceSessionProvider.lookup((String)session.getProvider()).orElseGet(UnknownDeviceSessionProvider::getInstance);
        return provider.serialize(session, registry).map(Base64::encodeBase64String).doOnNext(entity::setSessionBase64).thenReturn((Object)entity);
    }

    public Mono<PersistentSession> toSession(DeviceRegistry registry) {
        DeviceSessionProvider provider = DeviceSessionProvider.lookup((String)this.getProvider()).orElseGet(UnknownDeviceSessionProvider::getInstance);
        if (StringUtils.hasText((String)this.sessionBase64)) {
            return provider.deserialize(Base64.decodeBase64((String)this.sessionBase64), registry);
        }
        return Mono.empty();
    }

    public String getProvider() {
        return this.provider;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public Long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Long getLastKeepAliveTime() {
        return this.lastKeepAliveTime;
    }

    public String getSessionBase64() {
        return this.sessionBase64;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setKeepAliveTimeout(Long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setLastKeepAliveTime(Long lastKeepAliveTime) {
        this.lastKeepAliveTime = lastKeepAliveTime;
    }

    public void setSessionBase64(String sessionBase64) {
        this.sessionBase64 = sessionBase64;
    }
}

