/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.cluster;

import java.util.ArrayList;
import java.util.List;
import org.jetlinks.community.configure.cluster.Cluster;
import org.jetlinks.core.trace.TraceHolder;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jetlinks.cluster")
public class ClusterProperties {
    private static String NAME = "default";
    private String id = "default";
    private String name = NAME;
    private String externalHost;
    private Integer externalPort;
    private int port;
    private String rpcExternalHost;
    private Integer rpcExternalPort;
    private int rpcPort;
    private List<String> seeds = new ArrayList<String>();

    public void setId(String id) {
        this.id = id;
        Cluster.ID = id;
        TraceHolder.setupGlobalName((String)id);
    }

    public void setName(String name) {
        this.name = name;
        NAME = name;
    }

    public static String globalName() {
        return NAME;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getExternalHost() {
        return this.externalHost;
    }

    public Integer getExternalPort() {
        return this.externalPort;
    }

    public int getPort() {
        return this.port;
    }

    public String getRpcExternalHost() {
        return this.rpcExternalHost;
    }

    public Integer getRpcExternalPort() {
        return this.rpcExternalPort;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public List<String> getSeeds() {
        return this.seeds;
    }

    public void setExternalHost(String externalHost) {
        this.externalHost = externalHost;
    }

    public void setExternalPort(Integer externalPort) {
        this.externalPort = externalPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRpcExternalHost(String rpcExternalHost) {
        this.rpcExternalHost = rpcExternalHost;
    }

    public void setRpcExternalPort(Integer rpcExternalPort) {
        this.rpcExternalPort = rpcExternalPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public void setSeeds(List<String> seeds) {
        this.seeds = seeds;
    }
}

