/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community;

import com.cronutils.builder.CronBuilder;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronConstraintsFactory;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.FieldExpressionFactory;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.exception.ValidationException;
import org.jetlinks.community.TimerIterable;
import org.springframework.util.Assert;

public class TimerSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u89e6\u53d1\u65b9\u5f0f")
    @NotNull
    private Trigger trigger;
    @Schema(description="\u89e6\u53d1\u65b9\u5f0f\u4e3a[cron]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private String cron;
    @Schema(description="\u6267\u884c\u7684\u65f6\u95f4.\u4e3a\u7a7a\u5219\u8868\u793a\u6bcf\u5929,\u89e6\u53d1\u65b9\u5f0f\u4e3a[week]\u5219\u4e3a1-7,\u89e6\u53d1\u65b9\u5f0f\u4e3a[month]\u65f6\u5219\u4e3a1-31")
    private Set<Integer> when;
    @Schema(description="\u6267\u884c\u6a21\u5f0f,\u4e00\u6b21\u8fd8\u662f\u5468\u671f\u6267\u884c")
    private ExecuteMod mod;
    @Schema(description="\u6267\u884c\u6a21\u5f0f\u4e3a[period]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private Period period;
    @Schema(description="\u6267\u884c\u6a21\u5f0f\u4e3a[once]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private Once once;
    static int MAX_IT_TIMES = 10000;

    public static TimerSpec cron(String cron) {
        TimerSpec spec = new TimerSpec();
        spec.cron = cron;
        spec.trigger = Trigger.cron;
        return spec;
    }

    public Predicate<LocalDateTime> createRangeFilter() {
        if (CollectionUtils.isEmpty(this.when)) {
            return ignore -> true;
        }
        if (this.trigger == Trigger.week) {
            return date -> this.when.contains(date.getDayOfWeek().getValue());
        }
        if (this.trigger == Trigger.month) {
            return date -> this.when.contains(date.getDayOfMonth());
        }
        return ignore -> true;
    }

    public Predicate<LocalDateTime> createTimeFilter() {
        Predicate<LocalDateTime> range = this.createRangeFilter();
        if (this.mod == ExecuteMod.period) {
            LocalTime to = this.period.toLocalTime();
            LocalTime from = this.period.fromLocalTime();
            Predicate<LocalDateTime> predicate = time -> time.toLocalTime().compareTo(from) >= 0;
            if (to != null) {
                predicate = predicate.and(time -> time.toLocalTime().compareTo(to) <= 0);
            }
            return predicate.and(range);
        }
        if (this.mod == ExecuteMod.once) {
            LocalTime onceTime = this.once.localTime();
            Predicate<LocalDateTime> predicate = time -> time.toLocalTime().compareTo(onceTime) == 0;
            return predicate.and(range);
        }
        return range;
    }

    public String toCronExpression() {
        return this.toCron().asString();
    }

    private static CronDefinition quartz() {
        return CronDefinitionBuilder.defineCron().withSeconds().withValidRange(0, 59).and().withMinutes().withValidRange(0, 59).and().withHours().withValidRange(0, 23).and().withDayOfMonth().withValidRange(1, 31).supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().withValidRange(1, 12).and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(1).supportsHash().supportsL().supportsQuestionMark().and().withYear().withValidRange(1970, 2099).withStrictRange().optional().and().withCronValidation(CronConstraintsFactory.ensureEitherDayOfWeekOrDayOfMonth()).instance();
    }

    public Cron toCron() {
        LocalTime time;
        QuestionMark range;
        CronDefinition definition = TimerSpec.quartz();
        if (this.trigger == Trigger.cron || this.trigger == null) {
            Assert.hasText((String)this.cron, (String)"error.scene_rule_timer_cron_cannot_be_empty");
            return new CronParser(definition).parse(this.cron).validate();
        }
        CronBuilder builder = CronBuilder.cron((CronDefinition)definition);
        builder.withYear(FieldExpression.always());
        builder.withMonth(FieldExpression.always());
        if (CollectionUtils.isNotEmpty(this.when)) {
            On expr = null;
            for (Integer integer : this.when) {
                if (expr == null) {
                    expr = FieldExpressionFactory.on((int)integer);
                    continue;
                }
                expr = expr.and((FieldExpression)FieldExpressionFactory.on((int)integer));
            }
            range = expr;
        } else {
            range = FieldExpressionFactory.questionMark();
        }
        if (this.trigger == Trigger.week) {
            builder.withDoM((FieldExpression)FieldExpressionFactory.questionMark()).withDoW((FieldExpression)range);
        } else if (this.trigger == Trigger.month) {
            builder.withDoM((FieldExpression)range).withDoW((FieldExpression)FieldExpressionFactory.questionMark());
        }
        if (this.mod == ExecuteMod.once) {
            time = this.once.localTime();
            builder.withHour((FieldExpression)FieldExpressionFactory.on((int)time.getHour()));
            builder.withMinute((FieldExpression)FieldExpressionFactory.on((int)time.getMinute()));
            builder.withSecond((FieldExpression)FieldExpressionFactory.on((int)time.getSecond()));
        }
        if (this.mod == ExecuteMod.period) {
            time = this.period.fromLocalTime();
            PeriodUnit unit = this.period.unit;
            if (unit == PeriodUnit.hours) {
                builder.withHour((FieldExpression)FieldExpressionFactory.every((FieldExpression)FieldExpressionFactory.on((int)time.getHour()), (int)this.period.every)).withMinute((FieldExpression)FieldExpressionFactory.on((int)time.getMinute())).withSecond((FieldExpression)FieldExpressionFactory.on((int)time.getSecond()));
            } else if (unit == PeriodUnit.minutes) {
                builder.withHour((FieldExpression)FieldExpressionFactory.always()).withMinute((FieldExpression)FieldExpressionFactory.every((FieldExpression)FieldExpressionFactory.on((int)time.getMinute()), (int)this.period.every)).withSecond((FieldExpression)FieldExpressionFactory.on((int)time.getSecond()));
            } else if (unit == PeriodUnit.seconds) {
                builder.withHour((FieldExpression)FieldExpressionFactory.always()).withMinute((FieldExpression)FieldExpressionFactory.always()).withSecond((FieldExpression)FieldExpressionFactory.every((FieldExpression)FieldExpressionFactory.on((int)time.getSecond()), (int)this.period.every));
            }
        }
        return builder.instance().validate();
    }

    public void validate() {
        if (this.trigger == null) {
            Assert.hasText((String)this.cron, (String)"error.scene_rule_timer_cron_cannot_be_empty");
        }
        if (this.trigger == Trigger.cron) {
            try {
                this.toCronExpression();
            }
            catch (Throwable e) {
                ValidationException exception = new ValidationException("cron", "error.cron_format_error", new Object[]{this.cron});
                exception.addSuppressed(e);
                throw exception;
            }
        } else {
            this.nextDurationBuilder().apply(ZonedDateTime.now());
        }
    }

    private static LocalTime parsTime(String time) {
        return LocalTime.parse(time);
    }

    public Function<ZonedDateTime, Duration> nextDurationBuilder() {
        Function<ZonedDateTime, ZonedDateTime> nextTime = this.nextTimeBuilder();
        return time -> Duration.between(time, (Temporal)nextTime.apply((ZonedDateTime)time));
    }

    public Function<ZonedDateTime, ZonedDateTime> nextTimeBuilder() {
        TimerIterable it = this.iterable();
        return time -> it.iterator((ZonedDateTime)time).next();
    }

    private TimerIterable cronIterable() {
        Cron cron = this.toCron();
        final ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        final Predicate<LocalDateTime> filter = this.createTimeFilter();
        return baseTime -> new Iterator<ZonedDateTime>(){
            ZonedDateTime current;
            {
                this.current = baseTime;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public ZonedDateTime next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ZonedDateTime dateTime = this.current;
                int i = 0;
                do {
                    if ((dateTime = (ZonedDateTime)executionTime.nextExecution(dateTime).orElse(null)) == null) {
                        ++i;
                        continue;
                    }
                    if (filter.test(dateTime.toLocalDateTime())) break;
                } while (i < MAX_IT_TIMES);
                this.current = dateTime;
                return this.current;
            }
        };
    }

    private TimerIterable periodIterable() {
        Assert.notNull((Object)this.period, (String)"period can not be null");
        final Predicate<LocalDateTime> filter = this.createTimeFilter();
        final Duration duration = Duration.of(this.period.every, this.period.unit.temporal);
        LocalTime time = this.period.fromLocalTime();
        return baseTime -> new Iterator<ZonedDateTime>(){
            ZonedDateTime current;
            {
                this.current = baseTime;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public ZonedDateTime next() {
                ZonedDateTime dateTime = this.current;
                int max = MAX_IT_TIMES;
                while (!filter.test((dateTime = dateTime.plus(duration)).toLocalDateTime()) && --max > 0) {
                }
                this.current = dateTime;
                return this.current;
            }
        };
    }

    private TimerIterable onceIterable() {
        Assert.notNull((Object)this.once, (String)"once can not be null");
        final Predicate<LocalDateTime> filter = this.createTimeFilter();
        final LocalTime onceTime = this.once.localTime();
        return baseTime -> new Iterator<ZonedDateTime>(){
            ZonedDateTime current;
            {
                this.current = baseTime;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public ZonedDateTime next() {
                ZonedDateTime dateTime = this.current;
                int max = MAX_IT_TIMES;
                if (dateTime.toLocalTime().compareTo(onceTime) != 0) {
                    dateTime = onceTime.atDate(dateTime.toLocalDate()).atZone(dateTime.getZone());
                }
                do {
                    if (filter.test(dateTime.toLocalDateTime()) && this.current.compareTo(dateTime) <= 0) {
                        this.current = dateTime.plusDays(1L);
                        break;
                    }
                    dateTime = dateTime.plusDays(1L);
                } while (--max > 0);
                return dateTime;
            }
        };
    }

    public TimerIterable iterable() {
        if ((this.trigger == Trigger.cron || this.trigger == null) && this.cron != null) {
            return this.cronIterable();
        }
        return this.mod == ExecuteMod.period ? this.periodIterable() : this.onceIterable();
    }

    public List<ZonedDateTime> getNextExecuteTimes(ZonedDateTime from, long times) {
        ArrayList<ZonedDateTime> timeList = new ArrayList<ZonedDateTime>((int)times);
        Iterator<ZonedDateTime> it = this.iterable().iterator(from);
        for (long i = 0L; i < times; ++i) {
            timeList.add(it.next());
        }
        return timeList;
    }

    @NotNull
    public Trigger getTrigger() {
        return this.trigger;
    }

    public String getCron() {
        return this.cron;
    }

    public Set<Integer> getWhen() {
        return this.when;
    }

    public ExecuteMod getMod() {
        return this.mod;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Once getOnce() {
        return this.once;
    }

    public void setTrigger(@NotNull Trigger trigger) {
        this.trigger = trigger;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setWhen(Set<Integer> when) {
        this.when = when;
    }

    public void setMod(ExecuteMod mod) {
        this.mod = mod;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setOnce(Once once) {
        this.once = once;
    }

    public static enum PeriodUnit {
        seconds(ChronoUnit.SECONDS),
        minutes(ChronoUnit.MINUTES),
        hours(ChronoUnit.HOURS);

        private final TemporalUnit temporal;

        private PeriodUnit(TemporalUnit temporal) {
            this.temporal = temporal;
        }
    }

    public static enum ExecuteMod {
        period,
        once;

    }

    public static enum Trigger {
        week,
        month,
        cron;

    }

    public static class Period
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Schema(description="\u6267\u884c\u65f6\u95f4\u8303\u56f4\u4ece.\u683c\u5f0f:[hh:mm],\u6216\u8005[hh:mm:ss]")
        private String from;
        @Schema(description="\u6267\u884c\u65f6\u95f4\u8303\u56f4\u6b62.\u683c\u5f0f:[hh:mm],\u6216\u8005[hh:mm:ss]")
        private String to;
        @Schema(description="\u5468\u671f\u503c\uff0c\u5982:\u6bcf[every][unit]\u6267\u884c\u4e00\u6b21")
        private int every;
        @Schema(description="\u5468\u671f\u6267\u884c\u5355\u4f4d")
        private PeriodUnit unit;

        public LocalTime fromLocalTime() {
            return TimerSpec.parsTime(this.from);
        }

        public LocalTime toLocalTime() {
            return TimerSpec.parsTime(this.to);
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public int getEvery() {
            return this.every;
        }

        public PeriodUnit getUnit() {
            return this.unit;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setEvery(int every) {
            this.every = every;
        }

        public void setUnit(PeriodUnit unit) {
            this.unit = unit;
        }
    }

    public static class Once
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Schema(description="\u65f6\u95f4\u70b9.\u683c\u5f0f:[hh:mm],\u6216\u8005[hh:mm:ss]")
        @NotBlank
        private String time;

        public LocalTime localTime() {
            return TimerSpec.parsTime(this.time);
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        private Once(String time) {
            this.time = time;
        }

        public static Once of(String time) {
            return new Once(time);
        }

        public Once() {
        }
    }
}

