/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.things.data.AggregationRequest;
import org.jetlinks.community.things.data.PropertyAggregation;
import org.jetlinks.community.things.data.ThingEvent;
import org.jetlinks.community.things.data.ThingMessageLog;
import org.jetlinks.community.things.data.ThingPropertyDetail;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.things.data.operations.QueryOperations;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.Thing;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingsRegistry;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractQueryOperations
implements QueryOperations {
    protected final String thingType;
    protected final String thingTemplateId;
    protected final String thingId;
    protected final MetricBuilder metricBuilder;
    protected final DataSettings settings;
    protected final ThingsRegistry registry;

    protected abstract Flux<TimeSeriesData> doQuery(String var1, Query<?, QueryParamEntity> var2);

    protected abstract <T> Mono<PagerResult<T>> doQueryPage(String var1, Query<?, QueryParamEntity> var2, Function<TimeSeriesData, T> var3);

    protected abstract Flux<AggregationData> doAggregation(String var1, AggregationRequest var2, AggregationContext var3);

    protected Mono<ThingMetadata> getMetadata() {
        if (StringUtils.hasText((String)this.thingId)) {
            return this.registry.getThing(this.thingType, this.thingId).flatMap(Thing::getMetadata);
        }
        return this.registry.getTemplate(this.thingType, this.thingTemplateId).flatMap(ThingTemplate::getMetadata);
    }

    protected void applyQuery(Query<?, ? extends QueryParam> query) {
        if (CollectionUtils.isEmpty((Collection)query.getParam().getSorts())) {
            query.orderByDesc("timestamp");
        }
        if (StringUtils.hasText((String)this.thingId)) {
            query.and(this.metricBuilder.getThingIdProperty(), (Object)this.thingId);
        }
    }

    protected abstract Flux<ThingPropertyDetail> queryProperty(@Nonnull QueryParamEntity var1, @Nonnull ThingMetadata var2, @Nonnull Map<String, PropertyMetadata> var3);

    protected abstract Mono<PagerResult<ThingPropertyDetail>> queryPropertyPage(@Nonnull QueryParamEntity var1, @Nonnull ThingMetadata var2, @Nonnull Map<String, PropertyMetadata> var3);

    protected abstract Flux<ThingPropertyDetail> queryEachProperty(@Nonnull String var1, @Nonnull Query<?, QueryParamEntity> var2, @Nonnull ThingMetadata var3, @Nonnull Map<String, PropertyMetadata> var4);

    @Override
    @Nonnull
    public final Flux<ThingPropertyDetail> queryEachProperty(@Nonnull QueryParamEntity param, String ... property) {
        return this.getMetadata().flatMapMany(metadata -> {
            Map<String, PropertyMetadata> properties = this.getProperties((ThingMetadata)metadata, property);
            if (properties.isEmpty()) {
                return Mono.empty();
            }
            if (properties.size() == 1) {
                return this.queryProperty(param, (ThingMetadata)metadata, properties);
            }
            String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
            Query query = param.toNestQuery(this::applyQuery);
            return this.queryEachProperty(metric, (Query<?, QueryParamEntity>)query, (ThingMetadata)metadata, properties);
        });
    }

    @Override
    @Nonnull
    public final Flux<ThingPropertyDetail> queryProperty(@Nonnull QueryParamEntity query, String ... property) {
        return this.getMetadata().flatMapMany(metadata -> {
            Map<String, PropertyMetadata> properties = this.getProperties((ThingMetadata)metadata, property);
            if (properties.isEmpty()) {
                return Mono.empty();
            }
            return this.queryProperty(query.clone(), (ThingMetadata)metadata, properties);
        });
    }

    @Override
    @Nonnull
    public final Mono<PagerResult<ThingPropertyDetail>> queryPropertyPage(@Nonnull QueryParamEntity query, String ... property) {
        return this.getMetadata().flatMap(metadata -> {
            Map<String, PropertyMetadata> properties = this.getProperties((ThingMetadata)metadata, property);
            if (properties.isEmpty()) {
                return Mono.empty();
            }
            return this.queryPropertyPage(query.clone(), (ThingMetadata)metadata, properties);
        }).defaultIfEmpty((Object)PagerResult.of((int)0, new ArrayList(), (QueryParam)query));
    }

    private Map<String, PropertyMetadata> getProperties(ThingMetadata metadata, String ... property) {
        if (property.length == 0) {
            return metadata.getProperties().stream().collect(Collectors.toMap(Metadata::getId, Function.identity()));
        }
        Set<String> propertiesFilter = property.length == 1 ? Collections.singleton(property[0]) : new HashSet<String>(Arrays.asList(property));
        return metadata.getProperties().stream().filter(p -> propertiesFilter.contains(p.getId())).collect(Collectors.toMap(Metadata::getId, Function.identity()));
    }

    @Override
    @Nonnull
    public final Flux<AggregationData> aggregationProperties(@Nonnull AggregationRequest request, PropertyAggregation ... properties) {
        String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
        AggregationRequest aggRequest = request.copy();
        aggRequest.getFilter().toNestQuery(this::applyQuery);
        return this.getMetadata().flatMapMany(metadata -> this.doAggregation(metric, aggRequest, new AggregationContext((ThingMetadata)metadata, properties)));
    }

    @Override
    public Flux<ThingMessageLog> queryMessageLog(@Nonnull QueryParamEntity param) {
        String metric = this.metricBuilder.createLogMetric(this.thingType, this.thingTemplateId, this.thingId);
        Query query = param.toNestQuery(this::applyQuery);
        return this.doQuery(metric, query).map(data -> ThingMessageLog.of(data, this.metricBuilder.getThingIdProperty()));
    }

    @Override
    public Mono<PagerResult<ThingMessageLog>> queryMessageLogPage(@Nonnull QueryParamEntity param) {
        String metric = this.metricBuilder.createLogMetric(this.thingType, this.thingTemplateId, this.thingId);
        Query query = param.toNestQuery(this::applyQuery);
        return this.doQueryPage(metric, query, data -> ThingMessageLog.of(data, this.metricBuilder.getThingIdProperty()));
    }

    @Override
    @Nonnull
    public Mono<PagerResult<ThingEvent>> queryEventPage(@Nonnull String eventId, @Nonnull QueryParamEntity param, boolean format) {
        String metric;
        Query query = param.toNestQuery(this::applyQuery);
        if (this.settings.getEvent().eventIsAllInOne()) {
            metric = this.metricBuilder.createEventAllInOneMetric(this.thingType, this.thingTemplateId, this.thingId);
            query.and("event", (Object)eventId);
        } else {
            metric = this.metricBuilder.createEventMetric(this.thingType, this.thingTemplateId, this.thingId, eventId);
        }
        if (format) {
            return this.getMetadata().mapNotNull(metadata -> metadata.getEventOrNull(eventId)).flatMap(metadata -> this.doQueryPage(metric, query, data -> ThingEvent.of(data, this.metricBuilder.getThingIdProperty()).putFormat((EventMetadata)metadata))).defaultIfEmpty((Object)PagerResult.of((int)0, new ArrayList(), (QueryParam)param));
        }
        return this.doQueryPage(metric, query, data -> ThingEvent.of(data, this.metricBuilder.getThingIdProperty())).defaultIfEmpty((Object)PagerResult.of((int)0, new ArrayList(), (QueryParam)param));
    }

    @Override
    @Nonnull
    public final Flux<ThingEvent> queryEvent(@Nonnull String eventId, @Nonnull QueryParamEntity param, boolean format) {
        String metric;
        Query query = param.toNestQuery(this::applyQuery);
        if (this.settings.getEvent().eventIsAllInOne()) {
            metric = this.metricBuilder.createEventAllInOneMetric(this.thingType, this.thingTemplateId, this.thingId);
            query.and("event", (Object)eventId);
        } else {
            metric = this.metricBuilder.createEventMetric(this.thingType, this.thingTemplateId, this.thingId, eventId);
        }
        if (format) {
            return this.getMetadata().mapNotNull(metadata -> metadata.getEventOrNull(eventId)).flatMapMany(metadata -> this.doQuery(metric, query).map(data -> ThingEvent.of(data, this.metricBuilder.getThingIdProperty()).putFormat((EventMetadata)metadata)));
        }
        return this.doQuery(metric, query).map(data -> ThingEvent.of(data, this.metricBuilder.getThingIdProperty()));
    }

    public AbstractQueryOperations(String thingType, String thingTemplateId, String thingId, MetricBuilder metricBuilder, DataSettings settings, ThingsRegistry registry) {
        this.thingType = thingType;
        this.thingTemplateId = thingTemplateId;
        this.thingId = thingId;
        this.metricBuilder = metricBuilder;
        this.settings = settings;
        this.registry = registry;
    }

    protected static class AggregationContext {
        private final Map<String, String> propertyAlias;
        private final Map<String, PropertyAggregation> aliasToProperty;
        private final PropertyAggregation[] properties;
        private final ThingMetadata metadata;

        public AggregationContext(ThingMetadata metadata, PropertyAggregation ... properties) {
            this.metadata = metadata;
            this.properties = properties;
            this.propertyAlias = Arrays.stream(properties).collect(Collectors.toMap(PropertyAggregation::getAlias, PropertyAggregation::getProperty));
            this.aliasToProperty = Arrays.stream(properties).collect(Collectors.toMap(PropertyAggregation::getAlias, Function.identity()));
        }

        public Map<String, String> getPropertyAlias() {
            return this.propertyAlias;
        }

        public Map<String, PropertyAggregation> getAliasToProperty() {
            return this.aliasToProperty;
        }

        public PropertyAggregation[] getProperties() {
            return this.properties;
        }

        public ThingMetadata getMetadata() {
            return this.metadata;
        }
    }
}

