/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.types.ObjectType;

@Generated
public class ThingEvent
extends HashMap<String, Object> {
    private String thingId;

    public ThingEvent() {
    }

    public ThingEvent(Map<String, Object> map, String thingIdProperty) {
        super(map);
        this.thingId = (String)map.get(thingIdProperty);
    }

    public ThingEvent(TimeSeriesData data, String thingIdProperty) {
        this(data.getData(), thingIdProperty);
        this.putIfAbsent("timestamp", data.getTimestamp());
    }

    public static ThingEvent of(TimeSeriesData data, String thingIdProperty) {
        return new ThingEvent(data, thingIdProperty);
    }

    @Override
    @Hidden
    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public long getTimestamp() {
        return this.containsKey("timestamp") ? (Long)this.get("timestamp") : 0L;
    }

    public ThingEvent putFormat(EventMetadata metadata) {
        if (metadata != null) {
            DataType type = metadata.getType();
            if (type instanceof ObjectType) {
                Map val = (Map)type.format((Object)this);
                val.forEach((k, v) -> this.put(k + "_format", v));
            } else {
                this.put("value_format", type.format(this.get("value")));
            }
        } else {
            Object value = this.get("value");
            if (value instanceof Map) {
                ((Map)value).forEach((k, v) -> this.put(k + "_format", v));
            } else {
                this.put("value_format", this.get("value"));
            }
        }
        return this;
    }

    public String getThingId() {
        return this.thingId;
    }

    public void setThingId(String thingId) {
        this.thingId = thingId;
    }
}

