/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.jetlinks.community.codec.Serializers;
import org.jetlinks.community.things.data.ThingsDataWriter;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.things.ThingsDataManager;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.core.utils.StringBuilderUtils;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

public class LocalFileThingsDataManager
implements ThingsDataManager,
ThingsDataWriter {
    private static final int DEFAULT_MAX_STORE_SIZE_EACH_KEY = Integer.parseInt(System.getProperty("thing.data.store.max-size", "4"));
    protected final MVStore mvStore;
    private final Map<String, Integer> tagCache = new ConcurrentHashMap<String, Integer>();
    private final Map<Long, PropertyHistory> historyCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).build().asMap();
    private final MVMap<String, Integer> tagStore;
    private final MVMap<Long, PropertyHistory> history;

    private static MVStore open(String fileName) {
        return new MVStore.Builder().fileName(fileName).autoCommitBufferSize(65536).compress().keysPerPage(1024).cacheSize(64).open();
    }

    private static MVStore load(String fileName) {
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            return LocalFileThingsDataManager.open(fileName);
        }
        catch (Throwable err) {
            if (file.exists()) {
                file.renameTo(new File(fileName + "_load_err_" + System.currentTimeMillis()));
                file.delete();
                return LocalFileThingsDataManager.open(fileName);
            }
            throw err;
        }
    }

    public LocalFileThingsDataManager(String fileName) {
        this(LocalFileThingsDataManager.load(fileName));
    }

    public LocalFileThingsDataManager(MVStore store) {
        this.mvStore = store;
        this.tagStore = this.mvStore.openMap("tags");
        this.history = this.mvStore.openMap("store", (MVMap.MapBuilder)new MVMap.Builder().valueType((DataType)new HistoryType()));
    }

    public void shutdown() {
        for (Map.Entry<Long, PropertyHistory> entry : this.historyCache.entrySet()) {
            if (entry.getValue().stored) continue;
            entry.getValue().stored = true;
            this.history.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<Long, PropertyHistory> entry : this.history.entrySet()) {
            if (entry.getValue().stored) continue;
            this.history.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.mvStore.compactMoveChunks();
        this.mvStore.close(60000);
    }

    public Mono<ThingProperty> getLastProperty(String thingType, String thingId, String property, long baseTime) {
        PropertyHistory propertyStore = this.getHistory(thingType, thingId, property);
        if (propertyStore == null) {
            return this.lastPropertyNotFound(thingType, thingId, property, baseTime);
        }
        Property pro = propertyStore.getProperty(baseTime);
        if (pro == null) {
            return this.lastPropertyNotFound(thingType, thingId, property, baseTime);
        }
        return pro.toProperty(property);
    }

    protected Mono<ThingProperty> lastPropertyNotFound(String thingType, String thingId, String property, long baseTime) {
        return Mono.empty();
    }

    protected Mono<ThingProperty> firstPropertyNotFound(String thingType, String thingId, String property) {
        return Mono.empty();
    }

    public Mono<ThingProperty> getFirstProperty(String thingType, String thingId, String property) {
        PropertyHistory propertyStore = this.getHistory(thingType, thingId, property);
        if (propertyStore == null) {
            return this.firstPropertyNotFound(thingType, thingId, property);
        }
        Property pro = propertyStore.first;
        if (pro == null) {
            return this.firstPropertyNotFound(thingType, thingId, property);
        }
        return pro.toProperty(property);
    }

    public Mono<List<ThingProperty>> getProperties(String thingType, String thingId, String property, long baseTime) {
        return this.getProperties(thingType, thingId, property, 0L, baseTime);
    }

    public Mono<List<ThingProperty>> getProperties(String thingType, String thingId, String property, long from, long to) {
        PropertyHistory propertyStore = this.getHistory(thingType, thingId, property);
        if (propertyStore == null) {
            return Mono.empty();
        }
        return Mono.just(propertyStore.getProperties(property, from, to));
    }

    protected PropertyHistory getHistory(String thingType, String thingId, String property) {
        long key = this.getPropertyStoreKey(thingType, thingId, property);
        PropertyHistory his = this.historyCache.get(key);
        if (his != null) {
            return his;
        }
        his = (PropertyHistory)this.history.get((Object)key);
        if (his != null) {
            this.historyCache.putIfAbsent(key, his);
            return his;
        }
        return null;
    }

    public Mono<Long> getLastPropertyTime(String thingType, String thingId, long baseTime) {
        long time = this.scanProperty(thingType, thingId, 0L, baseTime, (init, arg, history) -> {
            Property store = history.getProperty((long)arg);
            if (store != null) {
                return Math.max(init, store.time);
            }
            return init;
        });
        return time == 0L ? Mono.empty() : Mono.just((Object)time);
    }

    protected <T, ARG> T scanProperty(String thingType, String thingId, T init, ARG arg, Function3<T, ARG, PropertyHistory, T> historyConsumer) {
        int maxLoop;
        long thingTag = this.getThingTag(thingType, thingId);
        int tagSize = this.tagStore.size();
        long fromTag = thingTag << 32;
        long toTag = fromTag + (long)tagSize;
        Long fromKey = (Long)this.history.higherKey((Object)fromTag);
        if (fromKey == null) {
            return init;
        }
        Long toKey = (Long)this.history.lowerKey((Object)toTag);
        Cursor cursor = this.history.cursor((Object)fromKey, (Object)toKey, false);
        if (cursor == null) {
            return init;
        }
        int loop = maxLoop = tagSize / 2;
        while (cursor.hasNext() && loop > 0) {
            long _tag = (Long)cursor.getKey() >> 32;
            if (_tag != thingTag) {
                --loop;
                cursor.next();
                continue;
            }
            loop = maxLoop;
            PropertyHistory propertyStore = (PropertyHistory)cursor.getValue();
            init = historyConsumer.apply(init, arg, (Object)propertyStore);
            cursor.next();
        }
        return init;
    }

    public Mono<Long> getFirstPropertyTime(String thingType, String thingId) {
        Long time = this.scanProperty(thingType, thingId, null, null, (init, arg, history) -> {
            Property store = ((PropertyHistory)history).first;
            if (store != null) {
                if (init == null) {
                    return store.time;
                }
                return Math.min(init, store.time);
            }
            return init;
        });
        return time == null ? Mono.empty() : Mono.just((Object)time);
    }

    protected final int getTag(String key) {
        return this.tagCache.computeIfAbsent(key, _key -> (Integer)this.tagStore.computeIfAbsent(_key, k -> this.tagStore.size() + 1));
    }

    protected ObjectOutput createOutput(ByteBuf buffer) {
        return Serializers.getDefault().createOutput((OutputStream)new ByteBufOutputStream(buffer));
    }

    protected ObjectInput createInput(ByteBuf buffer) {
        return Serializers.getDefault().createInput((InputStream)new ByteBufInputStream(buffer, true));
    }

    @Override
    @Nonnull
    public final Mono<Void> updateProperty(@Nonnull String thingType, @Nonnull String thingId, @Nonnull ThingProperty property) {
        return this.updateProperty(thingType, thingId, property.getProperty(), property.getTimestamp(), property.getValue(), property.getState());
    }

    protected long getThingTag(String thingType, String thingId) {
        return this.getTag(StringBuilderUtils.buildString((Object)thingType, (Object)thingId, (a, b, sb) -> sb.append((String)a).append(':').append((String)b)));
    }

    protected long getPropertyStoreKey(String thingType, String thingId, String property) {
        long thingTag = this.getThingTag(thingType, thingId);
        int propertyTag = this.getTag(property);
        return (thingTag << 32) + (long)propertyTag;
    }

    @Override
    @Nonnull
    public Mono<Void> updateProperty(@Nonnull String thingType, @Nonnull String thingId, @Nonnull String property, long timestamp, @Nonnull Object value, String state) {
        this.updateProperty0(thingType, thingId, property, timestamp, value, state);
        return Mono.empty();
    }

    protected final void updateProperty0(String thingType, String thingId, String property, long timestamp, Object value, String state) {
        long key = this.getPropertyStoreKey(thingType, thingId, property);
        PropertyHistory propertyStore = this.historyCache.computeIfAbsent(key, k -> (PropertyHistory)this.history.computeIfAbsent(k, k1 -> new PropertyHistory()));
        Property p = new Property();
        p.setTime(timestamp);
        p.setValue(value);
        p.setState(state);
        propertyStore.update(p);
        propertyStore.tryStore(key, (arg_0, arg_1) -> this.history.put(arg_0, arg_1));
    }

    protected final void updateProperty(String thingType, String thingId, String property, PropertyHistory propertyHistory) {
        long key = this.getPropertyStoreKey(thingType, thingId, property);
        PropertyHistory propertyStore = (PropertyHistory)this.history.computeIfAbsent((Object)key, ignore -> new PropertyHistory());
        if (propertyHistory.first != null) {
            propertyStore.update(propertyHistory.first);
        }
        if (propertyHistory.refs != null) {
            for (Property ref : propertyHistory.refs) {
                propertyStore.update(ref);
            }
        }
    }

    private class HistoryType
    extends BasicDataType<PropertyHistory> {
        private HistoryType() {
        }

        public int compare(PropertyHistory a, PropertyHistory b) {
            if (a.refs == null && b.refs == null) {
                return 0;
            }
            if (a.refs == null) {
                return -1;
            }
            if (b.refs == null) {
                return 1;
            }
            return Long.compare(a.refs[0].time, b.refs[0].time);
        }

        public int getMemory(PropertyHistory obj) {
            return obj.memory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(WriteBuffer buff, PropertyHistory data) {
            ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
            try (ObjectOutput output = LocalFileThingsDataManager.this.createOutput(buffer);){
                data.writeExternal(output);
                buff.put(buffer.nioBuffer());
                output.flush();
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)buffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(WriteBuffer buff, Object obj, int len) {
            ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
            try (ObjectOutput output = LocalFileThingsDataManager.this.createOutput(buffer);){
                for (int i = 0; i < len; ++i) {
                    ((PropertyHistory)Array.get(obj, i)).writeExternal(output);
                }
                output.flush();
                buff.put(buffer.nioBuffer());
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)buffer);
            }
        }

        public void read(ByteBuffer buff, Object obj, int len) {
            try (ObjectInput input = LocalFileThingsDataManager.this.createInput(Unpooled.wrappedBuffer((ByteBuffer)buff));){
                for (int i = 0; i < len; ++i) {
                    PropertyHistory data = new PropertyHistory();
                    data.readExternal(input);
                    Array.set(obj, i, data);
                }
            }
        }

        public PropertyHistory[] createStorage(int size) {
            return new PropertyHistory[size];
        }

        public PropertyHistory read(ByteBuffer buff) {
            PropertyHistory data = new PropertyHistory();
            try (ObjectInput input = LocalFileThingsDataManager.this.createInput(Unpooled.wrappedBuffer((ByteBuffer)buff));){
                data.readExternal(input);
            }
            return data;
        }
    }

    public static class Property
    implements Externalizable {
        private long time;
        private String state;
        private Object value;
        private volatile Mono<ThingProperty> _temp;

        public Mono<ThingProperty> toProperty(String property) {
            if (this._temp == null) {
                this._temp = Mono.just((Object)ThingProperty.of((String)property, (Object)this.value, (long)this.time, (String)this.state));
            }
            return this._temp;
        }

        public ThingProperty toPropertyNow(String property) {
            if (this._temp == null) {
                this._temp = Mono.just((Object)ThingProperty.of((String)property, (Object)this.value, (long)this.time, (String)this.state));
            }
            if (this._temp instanceof Callable) {
                return (ThingProperty)((Callable)this._temp).call();
            }
            return this._temp.toFuture().getNow(null);
        }

        public int memory() {
            int i = 8;
            if (this.state != null) {
                i += this.state.length() * 2;
            }
            i = this.value instanceof Number ? (i += 8) : (i += 64);
            return i;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.time);
            SerializeUtils.writeObject((Object)this.state, (ObjectOutput)out);
            SerializeUtils.writeObject((Object)this.value, (ObjectOutput)out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.time = in.readLong();
            this.state = (String)SerializeUtils.readObject((ObjectInput)in);
            this.value = SerializeUtils.readObject((ObjectInput)in);
        }

        public long getTime() {
            return this.time;
        }

        public String getState() {
            return this.state;
        }

        public Object getValue() {
            return this.value;
        }

        public Mono<ThingProperty> get_temp() {
            return this._temp;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void set_temp(Mono<ThingProperty> _temp) {
            this._temp = _temp;
        }
    }

    public static class PropertyHistory
    implements Externalizable {
        private Property first;
        private Property[] refs;
        private long minTime = -1L;
        private long elapsedTime;
        private boolean stored;

        public Property getProperty(long baseTime) {
            if (this.refs == null) {
                return null;
            }
            for (Property ref : this.refs) {
                if (ref == null || ref.time > baseTime) continue;
                return ref;
            }
            return null;
        }

        public List<ThingProperty> getProperties(String property, long from, long to) {
            if (this.refs == null) {
                return Collections.emptyList();
            }
            if (DEFAULT_MAX_STORE_SIZE_EACH_KEY == 0) {
                return Collections.emptyList();
            }
            ArrayList<ThingProperty> properties = new ArrayList<ThingProperty>(Math.min(32, DEFAULT_MAX_STORE_SIZE_EACH_KEY));
            for (Property ref : this.refs) {
                ThingProperty prop;
                if (ref == null || ref.time < from || ref.time >= to || (prop = ref.toPropertyNow(property)) == null) continue;
                properties.add(prop);
            }
            return properties;
        }

        public void tryStore(long key, BiConsumer<Long, PropertyHistory> store) {
            long now = System.currentTimeMillis();
            long elapsed = this.elapsedTime;
            this.elapsedTime = now;
            if (now - elapsed >= 5000L) {
                this.stored = true;
                store.accept(key, this);
            } else {
                this.stored = false;
            }
        }

        public void update(Property ref) {
            Property last;
            if (this.refs == null) {
                this.refs = new Property[0];
            }
            if (this.first == null || this.first.time >= ref.time) {
                this.first = ref;
            }
            if (this.minTime > 0L && ref.time < this.minTime) {
                return;
            }
            boolean newEl = false;
            if (this.refs.length < DEFAULT_MAX_STORE_SIZE_EACH_KEY) {
                this.refs = Arrays.copyOf(this.refs, this.refs.length + 1);
                newEl = true;
            }
            if ((last = this.refs[0]) == null || ref.time >= last.time || newEl) {
                this.refs[this.refs.length - 1] = ref;
            } else {
                for (int i = 1; i < this.refs.length; ++i) {
                    last = this.refs[i];
                    if (ref.time == last.time) {
                        this.refs[i] = ref;
                        continue;
                    }
                    if (ref.time <= last.time) continue;
                    System.arraycopy(this.refs, i, this.refs, i + 1, this.refs.length - i - 1);
                    this.refs[i] = ref;
                    break;
                }
            }
            Arrays.sort(this.refs, Comparator.comparingLong(r -> r == null ? 0L : -((Property)r).time));
            this.minTime = this.refs[this.refs.length - 1].time;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.refs.length);
            for (Property ref : this.refs) {
                ref.writeExternal(out);
            }
            out.writeBoolean(this.first != null);
            if (this.first != null) {
                this.first.writeExternal(out);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.stored = true;
            int len = in.readShort();
            this.refs = new Property[len];
            for (int i = 0; i < len; ++i) {
                this.refs[i] = new Property();
                this.refs[i].readExternal(in);
            }
            if (in.readBoolean()) {
                this.first = new Property();
                this.first.readExternal(in);
            }
        }

        public int memory() {
            int i = 0;
            if (this.first != null) {
                i += this.first.memory();
            }
            if (this.refs != null) {
                for (Property ref : this.refs) {
                    if (ref == null) continue;
                    i += ref.memory();
                }
            }
            return i;
        }
    }
}

