/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.executor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.web.bean.Converter;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.utils.ExpressionUtils;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.LambdaTaskExecutor;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DataMappingTaskExecutorProvider
implements TaskExecutorProvider {
    public static Converter converter = FastBeanCopier.DEFAULT_CONVERT;

    public String getExecutor() {
        return "data-mapping";
    }

    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)new LambdaTaskExecutor("Mapping", context, () -> {
            Config config = (Config)FastBeanCopier.copy((Object)context.getJob().getConfiguration(), (Object)new Config(), (String[])new String[0]);
            return data -> Mono.just((Object)data.newData(config.mapping(data.getData())));
        }));
    }

    public static class Mapping {
        private String target;
        private String source;
        private String type;
        private transient Class typeClass;

        public Mapping() {
        }

        public Mapping(String target, String source) {
            this.target = target;
            this.source = source;
        }

        public Mapping(String target, String source, String type) {
            this.target = target;
            this.source = source;
            this.type = type;
        }

        public Class<?> getTypeClass() {
            if (this.typeClass == null && this.type != null) {
                String lowerType;
                switch (lowerType = this.type.toLowerCase()) {
                    case "int": 
                    case "integer": {
                        this.typeClass = Integer.class;
                        return Integer.class;
                    }
                    case "string": {
                        this.typeClass = String.class;
                        return String.class;
                    }
                    case "double": {
                        this.typeClass = Double.class;
                        return Double.class;
                    }
                    case "decimal": {
                        this.typeClass = BigDecimal.class;
                        return BigDecimal.class;
                    }
                    case "boolean": {
                        this.typeClass = Boolean.class;
                        return Boolean.class;
                    }
                    case "date": {
                        this.typeClass = Date.class;
                        return Date.class;
                    }
                }
                this.typeClass = Class.forName(this.type);
                return this.typeClass;
            }
            if (this.typeClass == Void.class) {
                return null;
            }
            return this.typeClass;
        }

        public Object getData(Map<String, Object> sourceData) {
            Object data = sourceData.get(this.source);
            if (data == null && this.source.contains("${")) {
                data = ExpressionUtils.analytical((String)this.source, sourceData, (String)"spel");
            }
            if (data == null) {
                return null;
            }
            return this.getTypeClass() != null ? converter.convert(data, this.getTypeClass(), null) : data;
        }

        public String getTarget() {
            return this.target;
        }

        public String getSource() {
            return this.source;
        }

        public String getType() {
            return this.type;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setTypeClass(Class typeClass) {
            this.typeClass = typeClass;
        }
    }

    public static class Config {
        private List<Mapping> mappings = new ArrayList<Mapping>();
        private boolean keepSourceData = false;

        private Map<String, Object> toMap(Object source) {
            return (Map)FastBeanCopier.copy((Object)source, HashMap::new, (String[])new String[0]);
        }

        private Object mapping(Object data) {
            if (data instanceof Map) {
                return this.doMapping((Map)data);
            }
            if (data instanceof Collection) {
                Collection source = (Collection)data;
                return source.stream().map(this::toMap).map(this::doMapping).collect(Collectors.toList());
            }
            return data;
        }

        private Object doMapping(Map<String, Object> object) {
            HashMap<String, Object> newData = new HashMap<String, Object>();
            if (this.keepSourceData) {
                newData.putAll(object);
            }
            for (Mapping mapping : this.mappings) {
                Object data = mapping.getData(object);
                if (data == null) continue;
                newData.put(mapping.target, data);
            }
            return newData;
        }

        public List<Mapping> getMappings() {
            return this.mappings;
        }

        public boolean isKeepSourceData() {
            return this.keepSourceData;
        }

        public void setMappings(List<Mapping> mappings) {
            this.mappings = mappings;
        }

        public void setKeepSourceData(boolean keepSourceData) {
            this.keepSourceData = keepSourceData;
        }
    }
}

