/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.configuration;

import org.jetlinks.community.rule.engine.commons.TermsConditionEvaluator;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.RuleEngine;
import org.jetlinks.rule.engine.api.scheduler.Scheduler;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.api.worker.Worker;
import org.jetlinks.rule.engine.condition.ConditionEvaluatorStrategy;
import org.jetlinks.rule.engine.condition.DefaultConditionEvaluator;
import org.jetlinks.rule.engine.condition.supports.DefaultScriptEvaluator;
import org.jetlinks.rule.engine.condition.supports.ScriptConditionEvaluatorStrategy;
import org.jetlinks.rule.engine.condition.supports.ScriptEvaluator;
import org.jetlinks.rule.engine.defaults.DefaultRuleEngine;
import org.jetlinks.rule.engine.defaults.LocalScheduler;
import org.jetlinks.rule.engine.defaults.LocalWorker;
import org.jetlinks.rule.engine.model.DefaultRuleModelParser;
import org.jetlinks.rule.engine.model.RuleModelParserStrategy;
import org.jetlinks.rule.engine.model.antv.AntVG6RuleModelParserStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RuleEngineConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RuleEngineConfiguration.class);

    @Bean
    public DefaultRuleModelParser defaultRuleModelParser() {
        return new DefaultRuleModelParser();
    }

    @Bean
    public DefaultConditionEvaluator defaultConditionEvaluator() {
        return new DefaultConditionEvaluator();
    }

    @Bean
    public TermsConditionEvaluator termsConditionEvaluator() {
        return new TermsConditionEvaluator();
    }

    @Bean
    public AntVG6RuleModelParserStrategy antVG6RuleModelParserStrategy() {
        return new AntVG6RuleModelParserStrategy();
    }

    @Bean
    public Scheduler localScheduler(Worker worker) {
        LocalScheduler scheduler = new LocalScheduler("local");
        scheduler.addWorker(worker);
        return scheduler;
    }

    @Bean
    public BeanPostProcessor autoRegisterStrategy(final DefaultRuleModelParser defaultRuleModelParser, final DefaultConditionEvaluator defaultConditionEvaluator, final LocalWorker worker) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof RuleModelParserStrategy) {
                    defaultRuleModelParser.register((RuleModelParserStrategy)bean);
                }
                if (bean instanceof ConditionEvaluatorStrategy) {
                    defaultConditionEvaluator.register((ConditionEvaluatorStrategy)bean);
                }
                if (bean instanceof TaskExecutorProvider) {
                    worker.addExecutor((TaskExecutorProvider)bean);
                }
                return bean;
            }
        };
    }

    @Bean
    public ScriptEvaluator ruleEngineScriptEvaluator() {
        return new DefaultScriptEvaluator();
    }

    @Bean
    public ScriptConditionEvaluatorStrategy scriptConditionEvaluatorStrategy(ScriptEvaluator scriptEvaluator) {
        return new ScriptConditionEvaluatorStrategy(scriptEvaluator);
    }

    @Bean
    public LocalWorker localWorker(EventBus eventBus, ConditionEvaluator evaluator) {
        return new LocalWorker("local", "local", eventBus, evaluator);
    }

    @Bean
    public RuleEngine defaultRuleEngine(Scheduler scheduler) {
        return new DefaultRuleEngine(scheduler);
    }
}

