/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.protocol;

import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.jetlinks.community.topic.Topics;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.TraceDeviceMessageCodec;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.Feature;
import org.jetlinks.core.route.Route;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.DeviceGatewayContext;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Generated
public class RenameProtocolSupport
implements ProtocolSupport {
    public static final JetLinksDeviceMetadataCodec metadataCodec = new JetLinksDeviceMetadataCodec();
    private final String id;
    private final String name;
    private final String description;
    private final ProtocolSupport target;
    private final EventBus eventBus;

    public Flux<? extends Transport> getSupportedTransport() {
        return this.target.getSupportedTransport();
    }

    @Nonnull
    public Mono<? extends DeviceMessageCodec> getMessageCodec(Transport transport) {
        return this.target.getMessageCodec(transport).map(codec -> new TraceDeviceMessageCodec(this.id, codec));
    }

    public Mono<DeviceMessageSenderInterceptor> getSenderInterceptor() {
        return this.target.getSenderInterceptor();
    }

    @Nonnull
    public DeviceMetadataCodec getMetadataCodec() {
        return this.target.getMetadataCodec() == null ? metadataCodec : this.target.getMetadataCodec();
    }

    @Nonnull
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceOperator deviceOperation) {
        return this.target.authenticate(request, deviceOperation);
    }

    @Nonnull
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceRegistry registry) {
        return this.target.authenticate(request, registry);
    }

    public Mono<DeviceMetadata> getDefaultMetadata(Transport transport) {
        return this.target.getDefaultMetadata(transport);
    }

    public Flux<ConfigMetadata> getMetadataExpandsConfig(Transport transport, DeviceMetadataType metadataType, String metadataId, String dataTypeId) {
        return this.target.getMetadataExpandsConfig(transport, metadataType, metadataId, dataTypeId);
    }

    public Flux<DeviceMetadataCodec> getMetadataCodecs() {
        return this.target.getMetadataCodecs();
    }

    public Mono<ConfigMetadata> getInitConfigMetadata() {
        return this.target.getInitConfigMetadata();
    }

    @Nonnull
    public Mono<DeviceStateChecker> getStateChecker() {
        return this.target.getStateChecker();
    }

    public Mono<ConfigMetadata> getConfigMetadata(Transport transport) {
        return this.target.getConfigMetadata(transport);
    }

    public void init(Map<String, Object> configuration) {
        this.target.init(configuration);
    }

    public void dispose() {
        this.target.dispose();
    }

    public boolean isDisposed() {
        return this.target.isDisposed();
    }

    public Mono<Void> onDeviceUnRegister(DeviceOperator operator) {
        return this.target.onDeviceUnRegister(operator).then(this.eventBus.publish(Topics.deviceUnRegisterEvent((String)operator.getDeviceId()), (Object)operator.getDeviceId()).then());
    }

    public Mono<Void> onDeviceRegister(DeviceOperator operator) {
        return this.target.onDeviceRegister(operator).then(this.eventBus.publish(Topics.deviceRegisterEvent((String)operator.getDeviceId()), (Object)operator.getDeviceId()).then());
    }

    public Mono<Void> onProductRegister(DeviceProductOperator operator) {
        return this.target.onProductRegister(operator).then(this.eventBus.publish(Topics.productRegisterEvent((String)operator.getId()), (Object)operator.getId()).then());
    }

    public Mono<Void> onProductUnRegister(DeviceProductOperator operator) {
        return this.target.onProductUnRegister(operator).then(this.eventBus.publish(Topics.productUnRegisterEvent((String)operator.getId()), (Object)operator.getId()).then());
    }

    public Mono<Void> onDeviceMetadataChanged(DeviceOperator operator) {
        return this.target.onDeviceMetadataChanged(operator).then(this.eventBus.publish(Topics.deviceMetadataChangedEvent((String)operator.getDeviceId()), (Object)operator.getDeviceId()).then());
    }

    public Mono<Void> onProductMetadataChanged(DeviceProductOperator operator) {
        return this.target.onProductMetadataChanged(operator).then(this.eventBus.publish(Topics.productMetadataChangedEvent((String)operator.getId()), (Object)operator.getId()).then());
    }

    public Mono<Void> onChildBind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return this.target.onChildBind(gateway, child);
    }

    public Mono<Void> onChildUnbind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return this.target.onChildUnbind(gateway, child);
    }

    public Mono<Void> onClientConnect(Transport transport, ClientConnection connection, DeviceGatewayContext context) {
        return this.target.onClientConnect(transport, connection, context);
    }

    public Flux<Feature> getFeatures(Transport transport) {
        return this.target.getFeatures(transport);
    }

    public Mono<DeviceInfo> doBeforeDeviceCreate(Transport transport, DeviceInfo deviceInfo) {
        return this.target.doBeforeDeviceCreate(transport, deviceInfo);
    }

    public int getOrder() {
        return this.target.getOrder();
    }

    public int compareTo(ProtocolSupport o) {
        return this.target.compareTo(o);
    }

    public Flux<Route> getRoutes(Transport transport) {
        return this.target.getRoutes(transport);
    }

    public String getDocument(Transport transport) {
        return this.target.getDocument(transport);
    }

    public boolean isEmbedded() {
        return this.target.isEmbedded();
    }

    public RenameProtocolSupport(String id, String name, String description, ProtocolSupport target, EventBus eventBus) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.target = target;
        this.eventBus = eventBus;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

