/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.protocol;

import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.io.file.FileManager;
import org.jetlinks.community.utils.TimeUtils;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.jar.JarProtocolSupportLoader;
import org.jetlinks.supports.protocol.management.jar.ProtocolClassLoader;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AutoDownloadJarProtocolSupportLoader
extends JarProtocolSupportLoader {
    private static final Logger log = LoggerFactory.getLogger(AutoDownloadJarProtocolSupportLoader.class);
    final WebClient webClient;
    final File tempPath;
    private final Duration loadTimeout = TimeUtils.parse((String)System.getProperty("jetlinks.protocol.load.timeout", "30s"));
    private final FileManager fileManager;

    public AutoDownloadJarProtocolSupportLoader(WebClient.Builder builder, FileManager fileManager) {
        this.webClient = builder.build();
        this.fileManager = fileManager;
        this.tempPath = new File(System.getProperty("jetlinks.protocol.temp.path", "./data/protocols"));
        this.tempPath.mkdirs();
    }

    @Autowired
    @Generated
    public void setServiceContext(ServiceContext serviceContext) {
        super.setServiceContext(serviceContext);
    }

    @PreDestroy
    @Generated
    protected void closeAll() {
        super.closeAll();
    }

    protected void closeLoader(ProtocolClassLoader loader) {
        super.closeLoader(loader);
    }

    public Mono<? extends ProtocolSupport> load(ProtocolSupportDefinition definition) {
        ProtocolSupportDefinition newDef = (ProtocolSupportDefinition)FastBeanCopier.copy((Object)definition, (Object)new ProtocolSupportDefinition(), (String[])new String[0]);
        Map config = newDef.getConfiguration();
        String location = Optional.ofNullable(config.get("location")).map(String::valueOf).orElse(null);
        if (StringUtils.hasText((String)location) && location.startsWith("http")) {
            String urlMd5 = DigestUtils.md5Hex((String)location);
            File file2 = new File(this.tempPath, newDef.getId() + "_" + urlMd5 + ".jar");
            if (file2.exists()) {
                config.put("location", file2.getAbsolutePath());
                return super.load(newDef).subscribeOn(Schedulers.boundedElastic()).doOnError(err -> file2.delete());
            }
            return ((Mono)this.webClient.get().uri(location, new Object[0]).retrieve().bodyToFlux(DataBuffer.class).as(dataStream -> {
                log.debug("download protocol file {} to {}", (Object)location, (Object)file2.getAbsolutePath());
                return DataBufferUtils.write((Publisher)dataStream, (Path)file2.toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE}).thenReturn((Object)file2.getAbsolutePath());
            })).subscribeOn(Schedulers.boundedElastic()).doOnNext(path -> config.put("location", path)).then(super.load(newDef)).timeout(this.loadTimeout, Mono.error(() -> new TimeoutException("\u83b7\u53d6\u534f\u8bae\u6587\u4ef6\u5931\u8d25:" + location))).doOnError(err -> file2.delete());
        }
        String fileId = config.getOrDefault("fileId", null);
        if (!StringUtils.hasText((String)fileId)) {
            return Mono.error((Throwable)new IllegalArgumentException("location or fileId can not be empty"));
        }
        return this.loadFromFileManager(newDef.getId(), fileId).flatMap(file -> {
            config.put("location", file.getAbsolutePath());
            return super.load(newDef).subscribeOn(Schedulers.boundedElastic()).doOnError(err -> file.delete());
        });
    }

    private Mono<File> loadFromFileManager(String protocolId, String fileId) {
        Path path = Paths.get(this.tempPath.getPath(), protocolId + "_" + fileId + ".jar");
        File file = path.toFile();
        if (file.exists()) {
            return Mono.just((Object)file);
        }
        return DataBufferUtils.write((Publisher)this.fileManager.read(fileId), (Path)path, (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE}).thenReturn((Object)file);
    }
}

